

clear all
close all

% This experiment reproduces the results for HDR images rendering
% presented in the paper.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SCREEN PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This values can be adjusted for the particular screen.
scr_params.LM_out = 300; % asuming images in screen have maximum 300 cd/m²
scr_params.Lm_out = 5; % asuming images in screen have minimum 5 cd/m²
scr_params.gc = 2.2; % gamma correction factor
scr_params.N_steps = 300;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% IMAGE to process
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

filename = 'memorial.hdr';
fold = './IMAGES_EXP/';

Im_hdr = double(hdrread([fold filename]));
Im_hdr_g = (0.2126*Im_hdr(:,:,1) + 0.7152*Im_hdr(:,:,2) + 0.0722*Im_hdr(:,:,3));
Im_hdr_m = (Im_hdr_g - min(Im_hdr_g(:)))/(max(Im_hdr(:)) - min(Im_hdr_g(:)));


S_min = 5;
% Different maximum luminances
for S_max = [1e5 1e6 1e7]

        Im = (S_max-S_min)*Im_hdr_m + S_min;
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% NLP OPTIMIZATION 
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        [Im_out fX_n Im_out_scr] = NLP_rendering(Im,scr_params);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% SHOW RESULTS
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        figure, plot(fX_n,'linewidth',3), title(['objective evolution'])
        
        figure, imagesc(Im_out_scr,[0 1]), axis off, daspect([1 1 1]), 
        colormap gray, title('NLP Optimized image')
end
