
clear all
close all

% This experiment reproduces the results for details enhancement
% presented in the paper.

%% SCREEN PARAMETERS
% This values can be adjusted for the particular screen.
scr_params.LM_out = 300; % asuming images in screen have maximum 300 cd/m²
scr_params.Lm_out = 5; % asuming images in screen have minimum 5 cd/m²
scr_params.gc = 2.2; % gamma correction factor
scr_params.N_steps = 1000; 
    
%% IMAGE to process
% cropped version of the one used in Paris et al. 2011
im_name = 'Paris_flower.png';
fold = './IMAGES_EXP/';
Im_a = imread([fold im_name]);
Im_a = double(Im_a(:,120:680,:))/255;
Im_a_gray = (0.2126*Im_a(:,:,1) + 0.7152*Im_a(:,:,2) + 0.0722*Im_a(:,:,3)); 

%% IMAGE PARAMETERS
% Simulated luminance, bigger means more detail
S_max = 1000;
S_min = 5;
gc_im = 2.2; % gamma correction factor assumed in the image (sRGB standard)

% From Im to simulated luminance
Im_lum_ori = Im_a_gray.^gc_im; %
Im_lum_m = Im_lum_ori - min(Im_lum_ori(:));
Im = (S_max-S_min)*Im_lum_m/max(Im_lum_m(:)) + S_min;

% figure, imagesc((Im/scr_params.LM_out).^(1/scr_params.gc),[0 1]), colormap gray, axis off, daspect([1 1 1])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% NLP OPTIMIZATION (Using ADAM gradient optimization)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Im_out fX_n Im_out_scr] = NLP_rendering(Im,scr_params);

% figure, plot(fX_n), title('objective evolution')
figure, imagesc(Im_out_scr,[0 1]), axis off, daspect([1 1 1]), colormap gray, title('NLP Optimized image')
figure, imagesc(Im_a_gray/max(Im_a_gray(:)),[0 1]), axis off, daspect([1 1 1]), colormap gray, title('Original image')





