%% Exercise 1: Performing FFT on sin(x) and cosine(x) waves
% The goal of this exercise is to run the FFT on simple signals that are
% combinations of sin(x) and cosine(x) waves. By running FFT on these
% simple signals, we can gain a better intuition for the output of the
% fft() function.

close all;
% To begin, we will look at the fft of a cosine wave and a sine wave
% Create cos(x) and sin(x) ranging from angles 0 to 2*pi
angles = linspace(0, 2*pi, 100);
signal_cos = cos(angles);
signal_sin = sin(angles);

% Run FFT on cos(x) and sin(x) using fft() and fftshift()
fft_cos = fftshift(fft(signal_cos));
fft_sin = fftshift(fft(signal_sin));

% Use the modifier real() on the fft output of cos(x) and the fft output of sin(x).
% Plot both of these over the appropriate frequencies. Set the ylim to [-60, 60]. 
% What do you see? Does this make sense?
fft_cos_real = (real(fft_cos));
fft_sin_real = (real(fft_sin));

frequencies = linspace(-length(angles)/2, length(angles)/2);
figure;
subplot(2, 1, 1);
stem(frequencies, fft_cos_real)
ylim([-60, 60])
title('cos')

subplot(2, 1, 2);
stem(frequencies, fft_sin_real)
ylim([-60, 60])
title('sin')


% Use the modifier imag() on the fft output of cos(x) and the fft output of sin(x).
% Plot both of these over the appropriate frequencies. Set the ylim to [-60, 60]. 
% What do you see? Does this make sense?
fft_cos_imag = (imag(fft_cos));
fft_sin_imag = (imag(fft_sin));

figure;
subplot(2, 1, 1);
stem(frequencies, fft_cos_imag)
ylim([-60, 60])
title('cos')

subplot(2, 1, 2);
stem(frequencies, fft_sin_imag)
ylim([-60, 60])
title('sin')

% Now we are going to start combining waves. Create the following
% combinations:
% (1) cos(0)*cos(x) + sin(0)*sin(x)
% (2) cos(pi/6)*cos(x) + sin(pi/6)*sin(x)
% (3) cos(pi/4)*cos(x) + sin(pi/4)*sin(x)
% (4) cos(pi/3)*cos(x) + sin(pi/3)*sin(x)
% (5) cos(pi/2)*cos(x) + sin(pi/2)*sin(x)

wave_1 = cos(0)*signal_cos + sin(0)*signal_sin;
wave_2 = cos(pi/6)*signal_cos + sin(pi/6)*signal_sin;
wave_3 = cos(pi/4)*signal_cos + sin(pi/4)*signal_sin;
wave_4 = cos(pi/3)*signal_cos + sin(pi/3)*signal_sin;
wave_5 = cos(pi/2)*signal_cos + sin(pi/2)*signal_sin;

% Each of these waves are a combination of a cosine wave and sine wave of
% the same frequency. What does it mean to combine these waves?
% Plot these waves in different subplots. What do you notice?
figure;
subplot(5, 1, 1)
plot(angles, wave_1)
xlim([0, 2*pi])

subplot(5, 1, 2)
plot(angles, wave_2)
xlim([0, 2*pi])

subplot(5, 1, 3)
plot(angles, wave_3)
xlim([0, 2*pi])

subplot(5, 1, 4)
plot(angles, wave_4)
xlim([0, 2*pi])

subplot(5, 1, 5)
plot(angles, wave_5)
xlim([0, 2*pi])

% Now take the FFT of these waves. Plot the real component of the fft for 
% each wave combination (make ylim = [-60, 60]. Do the results make sense?
% What would you expect for the imaginary component?
fft_wave_1_real = real(fftshift(fft(wave_1)));
fft_wave_2_real = real(fftshift(fft(wave_2)));
fft_wave_3_real = real(fftshift(fft(wave_3)));
fft_wave_4_real = real(fftshift(fft(wave_4)));
fft_wave_5_real = real(fftshift(fft(wave_5)));

figure;
subplot(5, 1, 1)
stem(frequencies, fft_wave_1_real)
ylim([-60, 60])
title('wave 1')

subplot(5, 1, 2)
stem(frequencies, fft_wave_2_real)
ylim([-60, 60])
title('wave 2')

subplot(5, 1, 3)
stem(frequencies, fft_wave_3_real)
ylim([-60, 60])
title('wave 3')

subplot(5, 1, 4)
stem(frequencies, fft_wave_4_real)
ylim([-60, 60])
title('wave 4')

subplot(5, 1, 5)
stem(frequencies, fft_wave_5_real)
ylim([-60, 60])
title('wave 5')

% Let's take the angle() of the fft output for each wave. Find the angle
% corresponding to the frequency of k=1 for each wave. What do you notice
% happens to the angle as the waves shift?

fft_wave_1_angle = angle(fftshift(fft(wave_1)));
fft_wave_2_angle = angle(fftshift(fft(wave_2)));
fft_wave_3_angle = angle(fftshift(fft(wave_3)));
fft_wave_4_angle = angle(fftshift(fft(wave_4)));
fft_wave_5_angle = angle(fftshift(fft(wave_5)));

fft_angles = [fft_wave_1_angle(50), fft_wave_2_angle(50), fft_wave_3_angle(50), fft_wave_4_angle(50), fft_wave_5_angle(50)];
figure;
plot(fft_angles)
ylim([0, pi/2])

% Let's start adding cosine waves of different frequencies. Create the following:
% (1) cos(x)
% (2) cos(x) + cos(2x) + cos(3x)
% (3) cos(x) + 2*cos(2x) + 0.5cos(3x)
wave_6 = cos(angles);
wave_7 = cos(angles) + cos(2*angles) + cos(3*angles);
wave_8 = cos(angles) + 2*cos(2*angles) + 0.5*cos(3*angles);

% Now take the FFT of these waves. Plot the real component of the fft for 
% each wave combination (make ylim = [-10, 110]. Do the results make sense?
% What do you expect the imaginary components to look like?
fft_wave_6_real = real(fftshift(fft(wave_6)));
fft_wave_7_real = real(fftshift(fft(wave_7)));
fft_wave_8_real = real(fftshift(fft(wave_8)));

figure;
subplot(3, 1, 1)
stem(frequencies, fft_wave_6_real)
ylim([-10, 110])
title('wave 6')

subplot(3, 1, 2)
stem(frequencies, fft_wave_7_real)
ylim([-10, 110])
title('wave 7')

subplot(3, 1, 3)
stem(frequencies, fft_wave_8_real)
ylim([-10, 110])
title('wave 8')

% Finally, let's add cosine and sine waves of different frequencies. Create the following:
% (1) cos(x)
% (2) cos(x) + sin(2x) + cos(3x) + sin(4x)
% (3) cos(x) + cos(2x) + sin(2x) + 2*cos(3x) + 2*sin(3x)
wave_9 = cos(angles);
wave_10 = cos(angles) + sin(2*angles) + cos(3*angles) + sin(4*angles);
wave_11 = cos(angles) + cos(2*angles) + sin(2*angles) + 2*cos(3*angles) + 2*sin(3*angles);

% Now take the FFT of these waves. Plot the real component of the fft for 
% each wave combination (make ylim = [-10, 110]). What do you notice?
fft_wave_9_real = real(fftshift(fft(wave_9)));
fft_wave_10_real = real(fftshift(fft(wave_10)));
fft_wave_11_real = real(fftshift(fft(wave_11)));

figure;
subplot(3, 1, 1)
stem(frequencies, fft_wave_9_real)
ylim([-10, 110])
title('wave 9 - real')

subplot(3, 1, 2)
stem(frequencies, fft_wave_10_real)
ylim([-10, 110])
title('wave 10 - real')

subplot(3, 1, 3)
stem(frequencies, fft_wave_11_real)
ylim([-10, 110])
title('wave 11 - real')

% Now take the FFT of these waves. Plot the imaginary component of the fft for 
% each wave combination (make ylim = [-110, 110]). What do you notice?
fft_wave_9_imag = imag(fftshift(fft(wave_9)));
fft_wave_10_imag = imag(fftshift(fft(wave_10)));
fft_wave_11_imag = imag(fftshift(fft(wave_11)));

figure;
subplot(3, 1, 1)
stem(frequencies, fft_wave_9_imag)
ylim([-110, 110])
title('wave 9 - imag')

subplot(3, 1, 2)
stem(frequencies, fft_wave_10_imag)
ylim([-110, 110])
title('wave 10 - imag')

subplot(3, 1, 3)
stem(frequencies, fft_wave_11_imag)
ylim([-110, 110])
title('wave 11 - imag')

% Clearly, information is missing when using real or imag alone. Try using
% abs() on the fft output and plotting the results. (make ylim = [-10, 175])
fft_wave_9_abs = abs(fftshift(fft(wave_9)));
fft_wave_10_abs = abs(fftshift(fft(wave_10)));
fft_wave_11_abs = abs(fftshift(fft(wave_11)));

figure;
subplot(3, 1, 1)
stem(frequencies, fft_wave_9_abs)
ylim([-10, 175])
title('wave 9 - abs')

subplot(3, 1, 2)
stem(frequencies, fft_wave_10_abs)
ylim([-10, 175])
title('wave 10 - abs')

subplot(3, 1, 3)
stem(frequencies, fft_wave_11_abs)
ylim([-10, 175])
title('wave 11 - abs')

%% Exercise 2: Removing Noise
% The goal of this exercise is to perform fft and convolution on fairly
% simple signals to understand the mechanics of what is happening
close all;

% We will be trying to de-noise a simple combination of sine waves
x = linspace(0, 2*pi, 300);
y = 15*sin(x) + 4*sin(3*x) + 2*sin(5*x) + sin(7*x) + 0.5*sin(9*x) + 4*sin(51*x);

% Let's take a look at our signal
figure;
plot(x, y)

% The signal looks quite noisy. Let's try to use a shift-invariant linear system
% to de-noise the signal. To begin, plot the fft of the signal. What frequency range is causing 
% our noise issues?
y_ftt = abs(fftshift(fft(y)));
frequencies = linspace(-length(x)/2, length(x)/2, 300);
figure;
stem(frequencies, y_ftt)

% Let's create a guassian filter that can de-noise the signal. We will make
% several guassian filters, each with different spread:
sigma_1 = 1;
sigma_2 = 5;
sigma_3 = 30;

sample_num = length(x);
samples = (1:1:sample_num) - sample_num/2;

gaussian_1 = exp(-1*(samples.^2)/(2*sigma_1^2));
gaussian_2 = exp(-1*(samples.^2)/(2*sigma_2^2));
gaussian_3 = exp(-1*(samples.^2)/(2*sigma_3^2));

% Plot the FFT of each filter in subplots. Which filter do you think will
% work best to de-noise the signal? Why?
figure;

subplot(3,1,1)
gaussian_1_fft = abs(fftshift(fft(gaussian_1)));
stem(frequencies, gaussian_1_fft)

subplot(3,1,2)
gaussian_2_fft = abs(fftshift(fft(gaussian_2)));
stem(frequencies, gaussian_2_fft)

subplot(3,1,3)
gaussian_3_fft = abs(fftshift(fft(gaussian_3)));
stem(frequencies, gaussian_3_fft)

% Let's test each filter out in two different ways. First, the long way... 
% Use the formula ifft(R*fft(signal)) to get the filtered signal

% Filter #1
r_1 = fft(gaussian_1);
R_mat_1 = zeros(length(x));
for ii = 1:length(x)
    R_mat_1(ii, ii) = r_1(ii);
end
y_filter_1_long = ifft(R_mat_1 * fft(y)');

% Filter #2
r_2 = fft(gaussian_2);
R_mat_2 = zeros(length(x));
for ii = 1:length(x)
    R_mat_2(ii, ii) = r_2(ii);
end
y_filter_2_long = ifft(R_mat_2 * fft(y)');

% Filter #3
r_2 = fft(gaussian_2);
R_mat_3 = zeros(length(x));
r_3 = fft(gaussian_3);
for ii = 1:length(x)
    R_mat_3(ii, ii) = r_3(ii);
end
y_filter_3_long = ifft(R_mat_3 * fft(y)');

figure;
subplot(3,1,1)
plot(x, y_filter_1_long)
subplot(3,1,2)
plot(x, y_filter_2_long)
subplot(3,1,3)
plot(x, y_filter_3_long)

% Now let's test the filters using the short method: convolution
y_filter_1 = conv(y, gaussian_1, 'same');
y_filter_2 = conv(y, gaussian_2, 'same');
y_filter_3 = conv(y, gaussian_3, 'same');

figure;
subplot(3,1,1)
plot(x, y_filter_1)
subplot(3,1,2)
plot(x, y_filter_2)
subplot(3,1,3)
plot(x, y_filter_3)

% Which filter was best? Did this match your predictions? What does this
% tell us about the interactions between filters and signals in Fourier
% space?









