%% Exercise 1: Performing FFT on sin(x) and cosine(x) waves
% The goal of this exercise is to run the FFT on simple signals that are
% combinations of sin(x) and cosine(x) waves. By running FFT on these
% simple signals, we can gain a better intuition for the output of the
% fft() function.

close all;
% To begin, we will look at the fft of a cosine wave and a sine wave
% Create cos(x) and sin(x) ranging from angles 0 to 2*pi
angles = linspace(0, 2*pi, 100);
signal_cos = cos(angles);
signal_sin = sin(angles);

% Run FFT on cos(x) and sin(x) using fft() and fftshift()


% Use the modifier real() on the fft output of cos(x) and the fft output of sin(x).
% Plot both of these over the appropriate frequencies. Set the ylim to [-60, 60]. 
% What do you see? Does this make sense?



% Use the modifier imag() on the fft output of cos(x) and the fft output of sin(x).
% Plot both of these over the appropriate frequencies. Set the ylim to [-60, 60]. 
% What do you see? Does this make sense?


% Now we are going to start combining waves. Create the following
% combinations:
% (1) cos(0)*cos(x) + sin(0)*sin(x)
% (2) cos(pi/6)*cos(x) + sin(pi/6)*sin(x)
% (3) cos(pi/4)*cos(x) + sin(pi/4)*sin(x)
% (4) cos(pi/3)*cos(x) + sin(pi/3)*sin(x)
% (5) cos(pi/2)*cos(x) + sin(pi/2)*sin(x)

wave_1 = cos(0)*signal_cos + sin(0)*signal_sin;
wave_2 = cos(pi/6)*signal_cos + sin(pi/6)*signal_sin;
wave_3 = cos(pi/4)*signal_cos + sin(pi/4)*signal_sin;
wave_4 = cos(pi/3)*signal_cos + sin(pi/3)*signal_sin;
wave_5 = cos(pi/2)*signal_cos + sin(pi/2)*signal_sin;

% Each of these waves are a combination of a cosine wave and sine wave of
% the same frequency. What does it mean to combine these waves?
% Plot these waves in different subplots. What do you notice?


% Now take the FFT of these waves. Plot the real component of the fft for 
% each wave combination (make ylim = [-60, 60]. Do the results make sense?
% What would you expect for the imaginary component?


% Let's take the angle() of the fft output for each wave. Find the angle
% corresponding to the frequency of k=1 for each wave. What do you notice
% happens to the angle as the waves shift?



% Let's start adding cosine waves of different frequencies. Create the following:
% (1) cos(x)
% (2) cos(x) + cos(2x) + cos(3x)
% (3) cos(x) + 2*cos(2x) + 0.5cos(3x)
wave_6 = cos(angles);
wave_7 = cos(angles) + cos(2*angles) + cos(3*angles);
wave_8 = cos(angles) + 2*cos(2*angles) + 0.5*cos(3*angles);

% Now take the FFT of these waves. Plot the real component of the fft for 
% each wave combination (make ylim = [-10, 110]. Do the results make sense?
% What do you expect the imaginary components to look like?


% Finally, let's add cosine and sine waves of different frequencies. Create the following:
% (1) cos(x)
% (2) cos(x) + sin(2x) + cos(3x) + sin(4x)
% (3) cos(x) + cos(2x) + sin(2x) + 2*cos(3x) + 2*sin(3x)
wave_9 = cos(angles);
wave_10 = cos(angles) + sin(2*angles) + cos(3*angles) + sin(4*angles);
wave_11 = cos(angles) + cos(2*angles) + sin(2*angles) + 2*cos(3*angles) + 2*sin(3*angles);

% Now take the FFT of these waves. Plot the real component of the fft for 
% each wave combination (make ylim = [-10, 110]). What do you notice?


% Now take the FFT of these waves. Plot the imaginary component of the fft for 
% each wave combination (make ylim = [-110, 110]). What do you notice?


% Clearly, information is missing when using real or imag alone. Try using
% abs() on the fft output and plotting the results. (make ylim = [-10, 175])


%% Exercise 2: Removing Noise
% The goal of this exercise is to perform fft and convolution on fairly
% simple signals to understand the mechanics of what is happening
close all;

% We will be trying to de-noise a simple combination of sine waves
x = linspace(0, 2*pi, 300);
y = 15*sin(x) + 4*sin(3*x) + 2*sin(5*x) + sin(7*x) + 0.5*sin(9*x) + 4*sin(51*x);

% Let's take a look at our signal
figure;
plot(x, y)

% The signal looks quite noisy. Let's try to use a shift-invariant linear system
% to de-noise the signal. To begin, plot the fft of the signal. What frequency range is causing 
% our noise issues?


% Let's create a guassian filter that can de-noise the signal. We will make
% several guassian filters, each with different a different spread. Feel
% free to plot these filters.
sigma_1 = 1;
sigma_2 = 5;
sigma_3 = 30;

sample_num = length(x);
samples = (1:1:sample_num) - sample_num/2;

gaussian_1 = exp(-1*(samples.^2)/(2*sigma_1^2));
gaussian_2 = exp(-1*(samples.^2)/(2*sigma_2^2));
gaussian_3 = exp(-1*(samples.^2)/(2*sigma_3^2));

% Plot the FFT of each filter in subplots. Which filter do you think will
% work best to de-noise the signal? Why?


% Let's test each filter out in two different ways. First, the long way... 
% Use the formula ifft(R*fft(signal)) to get the filtered signal



% Now let's test the filters using the short method: convolution


% Which filter was best? Did this match your predictions? What does this
% tell us about the interactions between filters and signals in Fourier
% space?









