%% Math tools Lab 5
% Original code by Pascal Wallisch (~2017), modified by Perri Katzman
% (2018)

%% 1 Modeling event-related fMRI BOLD signal
% Convolution with the HRF

clear all
close all
clc 
load('hrf.mat'); 

% plot the hrf to see what it looks like
figure
plot(hrf)
title('canonical hrf')

% what do you notice about the signal?

% quick aside: this is what you'd see sampling at the standard 2s TR:
figure
hold on
plot(hrf)
scatter(2:2:19, hrf(2:2:19))
title('canonical hrf, TR = 2 s')

close

% Assume we have a very brief stimulus that we predict will elicit 
% activity in the voxel we care about. We can represent this activity with
% a single 1 in a vector of zeros:

taskDesign = zeros(1,100);
eventTR = 30;
taskDesign(eventTR) = 1;

% The neural activity will cause the relative levels of deoxygenated blood
% in the voxel to change, which is reflected in the bold response. 
predResp = convn(taskDesign, hrf, 'same'); %predicted response

figure
hold on
plot(predResp)
% plot impulse response
plot([eventTR, eventTR], [0 1], 'k') 
title('Impulse and corresponding response')
% ??? that doesn't look like an event-triggered response... why??

% where does the hrf appear in the predicted response?

delay = eventTR - ceil(length(hrf)/2); % y tho

figure
for ii = 1:length(hrf)
    % plot kernel and incrementally highlight each point
    subplot(1,2,1)
    plot(hrf,'b')
    hold on
    title('canonical hrf')
    scatter(ii,hrf(ii),'r')
    hold off
    
    % plot response and incrementally highlight corresponding point
    subplot(1,2,2)
    plot(predResp,'b')
    hold on
    plot([eventTR, eventTR], [0 1], 'k') % plot impulse response
    title('Impulse and corresponding response')
    scatter(delay+ii, predResp(delay+ii),'r')
    hold off
    pause
    shg
end

% Because past research has repeatedly demonstrated that the peak should be
% ~6 seconds after the stimulus, how can we change the kernel so that our
% predicted response is actually what we would predict?

paddedhrf = [zeros(1,20) hrf]; % why 20?
newPredResp = convn(taskDesign, paddedhrf, 'same');

% plot our predicted response, as we actually would predict
figure
plot(newPredResp,'b')
hold on
plot([eventTR, eventTR], [0 1], 'k') % plot impulse response
scatter(eventTR+6, newPredResp(eventTR+6),'r') % plot point 6 seconds after onset
title('Impulse and corresponding response (for real)')

% ACTIVITY:
% Add more trials to your experiment, see what happens when you have them
% closer in time and farther apart. Create a loop where the second trial
% starts off immediately after the first event, and incrementally gets
% later in time. Plot the corresponding predicted responses and note how
% they change.






%% 2 Convolution to de-noise LFP data
clear all
close all
clc 
load('LFPdata.mat'); 
%After loading, the workspace will contain a variable "A" that contains
%10,000 voltage samples per second, but only for 300 milliseconds. They
%represent the "local field potential", voltages in microvolt at the
%electrode tip. 

% plot the data
figure
plot(A)
shg

%By visual inspection, we note the presence of a signal, but also of a lot
%of "noise". The "sharp stuff" in particular does not look very
%physiological. There are no known processes in the brain that could
%generate such signals. But there are a lot of known problems with
%electrical noise that could. Solution: Smoothing by convolution.

%Problem: How big should we make the kernel? 

%%  Convolution: testing kernel sizes 
% Try a bunch of kernel sizes and see what looks best

% Any hypotheses? Any physiologists in the room?

for ii = 1:length(A) % go all the way
    kernelSize = ii; %This is the length of any given kernel
    kernel = ones(kernelSize,1); %Symmetric, equal weights, the simplest one
    kernel = kernel./sum(kernel); %normalize so that the output values don't scale with kernel length
    pause(0.15)
    Aconv = conv(A,kernel,'valid');
    plot(Aconv)
    title(['Kernel size = ', num2str(ii), ' samples'])
    ylim([-40 20]) % keep y axis constant
    xlim([-100 3100]) % keep x axis constant
    shg
end

% What seems like a good kernel size to minimize noise and keep our signal?

% What happens as the kernel gets larger?
%   - to the noise
%   - to the signal
%   - to the length of the output
%       ~ how could we change this aspect of the convolution?


%% 3 Moving on to 2D convolution. In the image domain. 
% Let's create luminance ramps - introducing meshgrid

numSteps = 7; %We want this many luminance steps
minLum = 0; %Lowest luminance value
maxLum = 255; %Highest luminance value in an 8 bit system
temp = linspace(minLum, maxLum, numSteps); %This creates them, we want to know the stepsize
stepSize = unique(round(diff(temp),4)); %Determine the stepsize from that
%To create an artificial 2d image, it is best to introduce the function
%"meshgrid" at this point. It has 2 outputs, x and y, which are a full
%cross of the inputs, keeping one dimension constant while incrementing the
%other one and vice versa. 
[x,y] = meshgrid(minLum:stepSize:maxLum,minLum:stepSize:maxLum); %This will create luminance ramps
figure
subplot(1,2,1)
imagesc(x)
subplot(1,2,2)
imagesc(y)
colorbar
colormap(bone)
shg

%% 4 Let's use this to create an artificial image
%Matlab represents images as 3D matrices. The first 2 dimensions are x and
%y coordinates, the third dimension are R,G and B sheets. The values
%represent luminances in 8 bit, so they range from 0 to 255.
clear IM %This will be a 3D matrix that represents the image. It will have 3 sheets, we create it one by one
IM(:,:,1) = uint8(x); %Red channel - the x's
IM(:,:,2) = uint8(zeros(length(x)));  %Silence the green channel to get purple
IM(:,:,3) = uint8(y); %Uint8 interprets/renders the values in 8 bit, as an unsigned integer.

% plot our image that gets decreasingly red in the x-dimension and
% decreasingly blue in the y-dimension
figure
subplot(1,2,1)
image(IM)
axis square
title('Unfiltered')

% make an averager kernel
kernel = ones(5); %Small summing kernel 
kernelWeight = sum(kernel(:)); %Sum of the flattened kernel. We need to sum in both dimensions
kernel = kernel ./ kernelWeight; %normalize to make it an averager
convIM = uint8(round(convn(IM, kernel, 'valid'))); 
subplot(1,2,2)
image(convIM)
axis square
title('Convolved')

% try with different "shapes": 'full', 'valid', 'same'

%% 5 Let's use an actual image

smidge = imread('smidge.jpg'); %put in matlab format
figure
image(smidge)
axis equal %Fix the aspect ratio to unstretch

%% 6 Let's convolve the image with a summing kernel = Blurring
kernelWidth = 50; 
figure
subplot(1,3,2)
image(smidge)
title('The Original Image')

subplot(1,3,1)
kernel = ones(kernelWidth);
kernelWeight = sum(kernel(:)); 
kernel = kernel/kernelWeight;
lp = uint8(convn(smidge,kernel,'same')); %Same makes sense for image processing
image(lp)
title('The Blurrier Image')

% What do you notice about the convolved image?

%% 7 Contrast enhancement with a difference filter = Sharpening
kernel = [];
% Make a contrast-enhancing filter, for example:
kernel(1,:) = [-1/9 -1/9 -1/9]; 
kernel(2,:) = [-1/9  1   -1/9]; 
kernel(3,:) = [-1/9 -1/9 -1/9]; 
kernelWeight = sum(kernel(:)); 
kernel = kernel ./ kernelWeight; % normalize
subplot(1,3,3) % add to figure
sharper = uint8(convn(smidge,kernel,'same'));
image(sharper)
title('The Sharper Image')
shg

% What do you notice about "the sharper image"?

%% 8 Activity
% Re-make the blurry image but try to decrease the edge artifacts.
% Alternatives for zero-padding:
%   - constant/mean ([3 3 3 1 2 3 4 5 3 3 3])
%   - reflectance ([3 2 1 1 2 3 4 5 5 4 3])
%   - circular ([3 4 5 1 2 3 4 5 1 2 3])



