% [PYR, PIND] = sublatt2pyr(LATTICES, LATTICE_INDICES, LDIMS)
%
% Inverse pyr2sublatt.  Reconstructs the pyramid from a matrix of 
% sublattices.
%
% EPS, 1/97

function [pyr, pind] = sublatt2pyr(lattices, lind, ldims)

pyr = [];
pind = [];
lnum = 1;

for bnum = 1:lind(size(lind,1))
  step = sqrt(sum( lind == bnum ));
  bdims = step*ldims;
  band = zeros(bdims);

  for y = 1:step
    for x = 1:step
      if ( lind(lnum) ~= bnum )
	error('Incorrect number of sublattices for this band');
	end
      latt = reshape(lattices(:,lnum), ldims);
      band(y:step:bdims(1), x:step:bdims(2)) = latt;
      lnum = lnum + 1;
      %fprintf(1,'band: %d, grid: (%d,%d)\n',bnum,x,y);
    end
  end

  pyr = [pyr ;  band(:)];
  pind = [pind ; bdims];
end
  
