% RANGE = showFlow (Vy, Vx, SUBSAMPLE, AMPLIFY)
%
% Display an optic flow vector field [Vy, Vx].
% Coordinate system matches that for an image (i.e., axis('ij')).
%
% The field is subsampled by a factor of SUBSAMPLE in each
% direction (default = 4).
%
% AMPLIFY determines the length of the drawn vectors.  A numerical
% value causes vectors to be drawn to their correct lengths (in pixels), 
% multiplied by that value.  The string 'auto' indicates auto-scaling: 
% the largest vector will be fit into the space between it and the 
% next vector. (default value = 1).  

function range = showFlow( Vy, Vx, subsample, amplify );

[ydim,xdim] = size(Vy);

if ((ydim ~= size(Vx,1)) | (xdim ~= size(Vx,2)))
  error('Velocity images must have same dimension');
end
  
if (exist('subsample') ~= 1)
  subsample = 4;  
end


if (exist('amplify') ~= 1)
  amplify = 1;
end

%% centered samples
ystart = 1+floor(mod((ydim+2)/2, subsample));
xstart = 1+floor(mod((xdim+2)/2, subsample));
ylatt = [ystart:subsample:ydim];
xlatt = [xstart:subsample:xdim];

if (amplify == 'auto')
  quiver(xlatt, ylatt, Vx(ylatt,xlatt), Vy(ylatt,xlatt));
else
  quiver(xlatt, ylatt, amplify*Vx(ylatt,xlatt), amplify*Vy(ylatt,xlatt),0);
end
axis('image'); 
axis('ij');
