% [LATTICES, LIND, LDIMS] = pyr2sublatt(PYR, PIND)
%
% Return a matrix with columns containing pyramid subband sublattices.
% These are subsampled versions of the original subbands with
% different subsampling origins, such that the full set of sublattices
% for each subband includes every sample of the original subband.
% Altogether, LATTICES contains all of the data of PYR.  The sampling
% rate is determined by the sampling of the coarsest scale band of the
% pyramid.
%
% EPS, 1/97

function [lattices, lind, ldims] = pyr2sublatt(pyr, pind)

ldims = pind(size(pind,1),:);

lattices = zeros(prod(ldims), size(pyr,1)/prod(ldims));
lind = zeros(size(pyr,1)/prod(ldims), 1);
lnum = 1;

for bnum = 1:size(pind,1)
  if (rem(pind(bnum,1), ldims(1)) ~= 0)
    error('Band dimensions must be multiples of the smallest band');
  elseif (rem(pind(bnum,2), ldims(2)) ~= 0)
    error('Band dimensions must be multiples of the smallest band');
  end

  band = pyrBand(pyr,pind,bnum);
  bdims = pind(bnum,:);
  step = bdims(1)/ldims(1);
  if ( bdims(2)/ldims(2) ~= step )
    error('Unequal subsampling in X and Y');
  end

  for y = 1:step
    for x = 1:step
      latt = band(y:step:bdims(1), x:step:bdims(2));
      lattices(:,lnum) = latt(:);
      lind(lnum) = bnum;
      lnum = lnum + 1;
      %fprintf(1,'band: %d, grid: (%d,%d)\n',bnum,x,y);
    end
  end
end

