function chm=modkurt(ch,k);

% Modify the kurtosis in one step, by moving in gradient direction until
% reaching the desired kurtosis value. 
% It does not affect the mean nor the variance, but it affects the skewness.
% This operation is not an orthogonal projection, but the projection angle is
% near pi/2 when k is close to the original kurtosis, which is a realistic assumption
% when doing iterative projections in a pyramid, for example (small corrections
% to the channels' statistics). 
%
% chm=modkurt(ch,k,var);
%	ch: channel
%	k: desired kurtosis (k=M4/M2^2)	

% Javier Portilla,  Oct.12/97, NYU

me=mean2(ch);
va=var2(ch);
ch=ch-me;

ch2=ch.^2;

% Compute the even moments

M2=zeros(6,1);
for n=1:6,
	M2(n)=mean2(ch2.^n);
end

% The original kurtosis

k0=M2(2)/M2(1)^2;

% Some auxiliar variables

a=M2(2)/M2(1);
dif2=M2(2)-k*M2(1)^2;
dif3=M2(3)-k*M2(1)*M2(2);
dif4=M2(4)-k/3*(2*M2(2)^2+M2(1)*M2(3));
dif5=M2(5)-k*M2(3)*M2(2);
dif6=M2(6)-k*M2(3)^2;

% Coeficients of the algebraic equation

c0=dif2;
c1=4*(-a*dif2+dif3);
c2=6*(a^2*dif2-2*a*dif3+dif4);
c3=4*(-a^3*dif2+3*a^2*dif3-3*a*dif4+dif5);
c4=a^4*dif2-4*a^3*dif3+6*a^2*dif4-4*a*dif5+dif6;

% Solves the equation

r=roots([c4 c3 c2 c1 c0]);

% Chose the real solution with minimum absolute value with the rigth sign

lam=Inf;
for n=1:4,
	if (imag(r(n))==0)&(sign(r(n))==sign(k-k0)),
		lam=min(abs(lam),abs(r(n))); 
	end
end
lam=sign(k-k0)*lam;
if abs(lam)==Inf,	% if there is no solution, just leave it untouched
	disp('Warning: kurtosis adjustment skipped!');
	lam=0;
end

% Modify the channel

%mean2(ch)
chm=ch+lam*(ch.^3-a*ch);	% adjust the kurtosis
%mean2(chm)
chm=chm*sqrt(va/mean2(chm.^2));	% adjust the variance
%mem=mean2(chm);
chm=chm+me;%-mem;			% adjust the mean

% Check the result
%k2=mean2((chm-mem).^4)/(mean2((chm-mem).^2))^2;
%SNR=snr(k,k-k2)








 
