function bands = makeWnbrs(pyr,pind,lev,ori,rnbrs,lfilt,crop)

% Compute a set of images containing  neighbors of coefficients in a
% given band, specified by LEV and ORI.
% PYR and PIND are the pyramid data structure.
% RNBRS should be an Nx4 matrix with columns giving RELATIVE scale,
% orientation, and [y,x]-position.  
% CROP (optional, default=0) is a scalar specifying the width of a 
% border region to remove.
%
% EPS, Spring 1998

% Mods:
%  5/4/98: added CROP argument.  

if (exist('lfilt') ~= 1) 
  lfilt = namedFilter('qmf9');
end

if (exist('crop') ~= 1)
  crop = 0;
end

maxori = 3;
maxlev = wpyrHt(pind);
%band = (lev-1)*maxori+ori;
rnbrs(:,1) = rnbrs(:,1) + lev;
%rnbrs(:,2) = rnbrs(:,2) + ori;
rnbrs(:,2) = 1 + mod(rnbrs(:,2)+ori-1, maxori);  %%MOD added 12/8/98

indices = find((rnbrs(:,1)>0)&(rnbrs(:,1)<=maxlev)&(rnbrs(:,2)>0)&(rnbrs(:,2)<=maxori));
if (length(indices) < size(rnbrs,1))
  warning(sprintf('Discarding %d neighbors with illegal specifications',...
      size(rnbrs,1)-length(indices)));
end
rnbrs = rnbrs(indices , :);

%% 3 columns: absolute band number, relative [Y,X]-position
%nbrs = [(rnbrs(:,1)-1)*maxori + rnbrs(:,2), rnbrs(:,3:4)];

for nnum = 1:size(rnbrs,1)
  %nbr = nbrs(nnum,1);
  nlev = rnbrs(nnum,1);
  nori = rnbrs(nnum,2);
  if ((nlev == lev) & (nori == ori))
    mctr = abs(rnbrs(nnum,3:4))+1;
    msz = 2*mctr-1;
    interp = mkImpulse(msz,mctr-rnbrs(nnum,3:4));
    nband = wpyrBand(pyr,pind,nlev,nori);    
  else 
     if (nlev > lev)
        firstBand = 1+maxori+maxori*(lev-1);
        firstInd = pyrBandIndices(pind,firstBand);	
        nband = reconWpyr(pyr(firstInd(1,1):size(pyr,1),1), ...
	    pind(firstBand:size(pind,1),:), lfilt, 'reflect1', nlev-lev, nori);
        nvodd = 0; nhodd = 0;
     else
        nband = wpyrBand(pyr, pind, nlev, nori);
        nvodd = mod(nori,2);   %odd vertical samples?
        nhodd = (nori>1);      %odd horiz samples?
     end
     vodd = mod(ori,2);
     hodd = (ori>1);

     mdisp = [nvodd-vodd, nhodd-hodd]+rnbrs(nnum,3:4);
     msz = 2*abs(mdisp)+[9 9];
     mctr = (msz+1)/2;
     interp = zeros(msz);
     interp(mctr(1)-4:mctr(1)+4,mctr(2)-4:mctr(2)+4)=lfilt*lfilt';
     interp = shift(interp,mdisp);
     interp = interp((2-mod(mctr(1),2)):2:msz(1),(2-mod(mctr(2),2)):2:msz(2));
  end
  iband = corrDn(nband, interp, 'reflect1');
  dims = size(iband);
  if (crop>0)
    iband = iband((1+crop):(dims(1)-crop), (1+crop):(dims(2)-crop)); 
  end
%  showIm(iband); pause  
  if (nnum == 1)
    bands = zeros(prod(size(iband)), size(rnbrs,1));
  end
  bands(:,nnum) = iband(:);     
end
