function bands = makeSnbrs(pyr,pind,lev,ori,rnbrs,causal)

% BANDS = makeSnbrs(PYR, PIND, LEV, ORI, RNBRS, CAUSAL)
%
% PYR and PIND are the pyramid data structure.
% RNBRS should be an Nx4 matrix with columns giving RELATIVE scale,
% orientation, and [y,x]-position.  
%
% Orientations are calculated modulo the number of orientation bands.
% [X,Y] positions are computed with reflection at boundaries.  Bands
% outside the range [1,maxlev] are discarded.  If CAUSAL is non-zero,
% only causal neighbors are included (i.e., a higher band number, or
% in the same band but earlier according to scan-line order).
%
% 12/12/98, EPS: Remove non-unique neighbors. 

if (exist('causal') ~= 1) 
  causal =  1;
end

%% taken from buildSFpyr.m:
if (exist('twidth') ~=1)
  twidth = 1;  
elseif (twidth <= 0)
  fprintf(1,'Warning: TWIDTH must be positive.  Setting to 1.\n');
  twidth = 1;
end

maxori = spyrNumBands(pind);
maxlev = spyrHt(pind);
bnum = 1+(lev-1)*maxori+ori;
dims = pind(bnum,:);

rnbrs(:,1) = rnbrs(:,1) + lev;
rnbrs(:,2) = 1 + mod(rnbrs(:,2)+ori-1, maxori);

nbrBnums =  1+maxori*(rnbrs(:,1)-1)+rnbrs(:,2);
if (causal)
  nbrRpos = dims(2)*rnbrs(:,3) + rnbrs(:,4);
  indices = find( ((nbrBnums==bnum) & (nbrRpos>0)) | (nbrBnums>bnum) );
  if (length(indices) < size(rnbrs,1))
    warning(sprintf('Discarding %d neighbors with noncausal specifications',...
	size(rnbrs,1)-length(indices)));
    rnbrs = rnbrs(indices , :);  
  end
end

% Check level numbers in [1,maxlev]:
indices = find((rnbrs(:,1)>=1)&(rnbrs(:,1)<=maxlev));
if (length(indices) < size(rnbrs,1))
  warning(sprintf('Discarding %d neighbors bad level specifications',...
      size(rnbrs,1)-length(indices)));
  rnbrs = rnbrs(indices , :);
end

unbrs = unique(rnbrs,'rows');
if (size(unbrs,1) < size(rnbrs,1))
  warning(sprintf('Discarding %d duplicated neighbors',...
      size(rnbrs,1)-size(unbrs,1)));
  rnbrs=unbrs;
end

%% Make cache matrix for bands
nbrBnums = unique(nbrBnums);
nbrBnums = [nbrBnums, zeros(size(nbrBnums,1),1)];
nbrBands = zeros([prod(dims), size(nbrBnums,1)]);

%% Taken from reconSFpyr.m:
if (any(rnbrs(:,1) > lev))
  ctr =   ceil((dims+0.5)/2);
  [xramp,yramp] = meshgrid( ([1:dims(2)]-ctr(2))./(dims(2)/2), ...
      ([1:dims(1)]-ctr(1))./(dims(1)/2) );
  angle = atan2(yramp,xramp);
  log_rad = sqrt(xramp.^2 + yramp.^2);
  log_rad(ctr(1),ctr(2)) =  log_rad(ctr(1),ctr(2)-1);
  log_rad  = log2(log_rad);
  [Xrcos,Yrcos] = rcosFn(twidth,(-twidth/2),[0 1]);
  Yrcos = sqrt(Yrcos);
end

bands = [];
for nnum = 1:size(rnbrs,1)
  nlev = rnbrs(nnum,1);
  nori = rnbrs(nnum,2);
  nbnum = 1+maxori*(nlev-1)+nori;
  nind = find(nbrBnums(:,1) == nbnum);
  if (prod(size(nind)) ~= 1)
    error('Busted');
  end

  if (nbrBnums(nind,2) < 0.5) % check flag - do we already  have nbr?
    if (nlev > lev)
      firstBand = max(2+maxori*(lev-1),1);
      firstInd = pyrBandIndices(pind,firstBand);	
      nbrdft = reconSFpyrLevs(pyr(firstInd(1,1):size(pyr,1),1), ...
	  pind(firstBand:size(pind,1),:), log_rad,Xrcos,Yrcos,angle,maxori, ...
	  [nlev-lev]+1, [nori]);
      %nbrBands(:,nind) = vectorize(real(ifft2(ifftshift(nbrdft))));
      nbrBands(:,nind) = reshape(real(ifft2(ifftshift(nbrdft))),prod(dims),1);
      nbrBnums(nind,2) = 1;      
    else    
      %nbrBands(:,nind) = vectorize(spyrBand(pyr, pind, nlev, nori));
      nbrBands(:,nind) = reshape(spyrBand(pyr, pind, nlev, nori),prod(dims),1);
      nbrBnums(nind,2) = 1;      
    end
  end

  mctr = abs(rnbrs(nnum,3:4))+1;
  if (any(mctr>1))
    msz = 2*mctr-1;
    interp = mkImpulse(msz,mctr-rnbrs(nnum,3:4));
    %nband = vectorize(corrDn(reshape(nbrBands(:,nind),dims), ...
    %	interp, 'reflect1'));
    nband = reshape(corrDn(reshape(nbrBands(:,nind),dims), ...
    	interp, 'reflect1'), prod(dims),1);
  else
    nband = nbrBands(:,nind);
  end    

  bands = [bands,nband(:)];     
end
