
%function Y = drawWwts(pyr,pind,lev,ori,rnbrs,wts, range)
% 
% pyr and pind are the pyramid data structure (orthonormal).
% rnbrs should be an Nx4 matrix with columns giving RELATIVE scale,
% orientation, and [y,x]-position. Positive x indicates to the left;
% positive y indicates up.
% wts are the prediction weights for predicting child at lev and ori.
% range is [black_value white_value]
% In resulting figure, brighter pixel values indicate higher weight values.
% The child is colored in red, and the neighbors are surrounded by a
% blue box.
% retvals is [lev ori] of weight matrix to be returned

function Y = drawWwts(pyr,pind,lev,ori,rnbrs,wts, range)

if (exist('range') ~= 1) | strcmp(range,'auto1')
  range = [min(wts) max(wts)];
end

maxori = 3;
maxlev=wpyrHt(pind);                   
maxspatial=max(max(abs(rnbrs(:,4))),max(abs(rnbrs(:,3))));
imdim=(2*maxspatial+1)+2;              %make room for max number of spatial 
                                       %blocks needed + 1 more pixel each dir.
backim=zeros(imdim);                   %background image
clf;

rnbrs(:,1) = rnbrs(:,1) + lev;
rnbrs(:,2) = rnbrs(:,2) + ori;
indices = find((rnbrs(:,1)>0)&(rnbrs(:,1)<=maxlev) ... %keep only correct nbrs
&(rnbrs(:,2)>0)&(rnbrs(:,2)<=maxori));
rnbrs = rnbrs(indices , :);
rnbrs(:,5) = wts;
rnbrs= [[lev ori 0 0 0]; rnbrs];                       %add child
rnbrs =sortrows(rnbrs);
maxlev=min(maxlev,max(abs(rnbrs(:,1))));               
minlev=min(abs(rnbrs(:,1)));

nnum=1;
if ~(strcmp(range,'indep1'))
   if minlev ~= maxlev subplot(2,1,2); end;          %thinner colorbar line
   colormap('gray')
   imagesc(backim, range);          %plot just to get correct colorbar range
   colorbar('hor')
end

for j=minlev:maxlev
   for k=1:maxori
      %note: maxlev-minlev+2 to leave room for colorbar at bottom of figure!
      subplot((maxlev-minlev+2),maxori,maxori*(j-minlev)+k) 
      currim=backim;
      oldnnum=nnum;
      
      %Put weight intensities in relevant spatial positions of level j and
      %ori k, by going through all neighbors at this level and orientation.
      if le(nnum,size(rnbrs,1)) 		
         while rnbrs(nnum,1)==j & rnbrs(nnum,2)==k       
            ymid = round(imdim/2)+(-1*rnbrs(nnum,3));
            xmid = round(imdim/2)+(-1*rnbrs(nnum,4));
            currim(ymid,xmid) = rnbrs(nnum,5);
            nnum=nnum+1;      
            if nnum > size(rnbrs,1) break; end		
         end
      end
      if strcmp(range,'indep1') 
         imagesc(currim, [min(min(currim)) max(max(currim))]);
         colorbar;
      else
         imagesc(currim, range);                      
      end
      axis('square'); 
       
      set(gca,'XTickLabel',[]);            %remove x and y axes labeling
      set(gca,'YTickLabel',[]);
      if (k==1 & j==minlev) title('horizontal'); end
      if (k==2 & j==minlev) title('vertical'); end
      if (k==3 & j==minlev) title('diagonal'); end
      if (k==1 & j==lev) ylabel(sprintf('level %d (child)',lev)); 
      elseif (k==1 & j~=lev)
         ylabel(sprintf('level %d', j));
      end 
      nnum=oldnnum;

      %put boxes around child and each neighbor
      set(gca,'COLOR', [1 0 0]);                       
      if le(nnum,size(rnbrs,1))
         while rnbrs(nnum,1)==j & rnbrs(nnum,2)==k
            yst = round(imdim/2)+(-1*rnbrs(nnum,3)) - .5;
            xst = round(imdim/2)+(-1*rnbrs(nnum,4)) - .5;
            yend=yst+ 1;          %subtr .5 from start and add to end
            xend=xst+ 1;          %for line and patch commands....
            if k==ori & j==lev & rnbrs(nnum,3)==0 & rnbrs(nnum,4)==0 %child
               patch([xst xend xend xst xst], ...  
               [yst yst yend yend yst], 'r');
            else                                                     %neighbor
               line([xst xend xend xst xst], ...
               [yst yst yend yend yst]);
            end
            nnum=nnum+1;      
            if nnum > size(rnbrs,1) break; end
         end
      end

end
end

