% [newX, M] = adjustCorr1(X, Cx, MODE) 
%
% Linearly adjust variables in X to have correlation Cx.
% Rows of X and newX are samples of a (random) row-vector, such that:
%    1:  newX = X * M    
%    2:  newX' * newX = Cx 
%
% MODE is optional:
%   0 => choose randomly from the space of linear solutions
%   1 => simplest soln
%   2 => minimize angle change (DEFAULT) 
%   3 => SVD minimal vector change soln

%  EPS, 11/23/97.

function [newX,M] = adjustCorr1(X,Co,mode)

if (exist('mode') ~= 1)
  mode = 2;
end

C = innerProd(X) / size(X,1);
[E, D] = eig(C);
D = diag(D);
[junk,Ind] = sort(D);
D = diag(sqrt(D(Ind(size(Ind,1):-1:1))));
E = E(:,Ind(size(Ind,1):-1:1));

[Eo,Do] = eig(Co);
Do = diag(Do);
[junk,Ind] = sort(Do);
Do = diag(sqrt(Do(Ind(size(Ind,1):-1:1))));
Eo = Eo(:,Ind(size(Ind,1):-1:1));

if (mode == 0)
  Orth = orth(rand(size(C)));
elseif (mode == 1) % eye
  Orth = eye(size(C));
elseif (mode == 2) % simple
  Orth = E' * Eo;
else     % SVD
  [U,S,V] = svd(D * E' * Eo * inv(Do));
  Orth = U * V';
end

M =  E * inv(D) * Orth * Do * Eo';

newX = X * M;
