%%%
%%% Q_WHITENOISE: MAKE WHITENOISE IMAGE.
%%%
%%%		Make a white noise image drawn from a uniform
%%%		distribution.  Final image is in the range [0 1]. 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_whitenoise( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	Q_window( parent );
	Q_sliders( parent, IM );
	Q_callbacks( parent );
	Q_whitenoise( str2num(sprintf('%d',parent)), 0, 1 );
else 
	if( mode == 1 ) % PREVIEW
		IM	= Q_get_iminfo( parent );
		vals	= Q_getvals( parent, IM );	
		s	= min( 1, 128 / max( vals(1), vals(2) ) );
		noise	= make_noise( s*vals(1), s*vals(2), vals(3) );
		Q_preview_im( noise, parent, 0, gray(256), [0 1] );
	elseif( mode == 2 ) % OK
		IM	= Q_get_iminfo( parent );
		vals	= Q_getvals( parent, IM );	
		noise	= make_noise( vals(1), vals(2), vals(3) );
		Q_resetfig( parent, IM );
		Q_main( noise, gray(256), [0 1], 1, 'gray', 'whitenoise' );
		return;
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'White Noise', 1, 1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent, IM )

	H 		= Q_get_handles( parent );
	[ydim,xdim] 	= size( IM.im );
	
	%%% XDIM/YDIM EDIT/LABEL 
	H.temp(1) = Q_input( parent, [0.72 0.37 0.1 0.06], xdim, 'edit' );
	H.temp(2) = Q_input( parent, [0.84 0.37 0.1 0.06], ydim, 'edit' );
	H.temp(3) = Q_input( parent, [0.5 0.37 0.2 0.06], 'X/Y size', 'text' );
	set( H.temp(3), 'FontSize', 12 );
	set( H.temp(3), 'HorizontalAlignment', 'right' );

	%%% POWER EDIT/LABEL
	H.temp(4) = Q_input( parent, [0.72 0.3 0.1 0.06], 100, 'edit' );
	H.temp(5) = Q_input( parent, [0.5 0.3 0.2 0.06], 'Power', 'text' );
	set( H.temp(5), 'FontSize', 12 );
	set( H.temp(5), 'HorizontalAlignment', 'right' );

	%%% POWER UNITS LABEL
	H.temp(6) = Q_input( parent, [0.84 0.3 0.1 0.06], '(%)','text');
	set( H.temp(6), 'FontSize', 12 );
	set( H.temp(6), 'HorizontalAlignment', 'left' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );
	cmd1 	= sprintf( 'Q_whitenoise(%d,0,1);', parent );
	cmd2 	= sprintf( 'Q_whitenoise(%d,0,2);', parent );

	%%% XDIM/YDIM/RADIUS
	set( H.temp(1), 'Callback', cmd1 );
	set( H.temp(2), 'Callback', cmd1 );
	set( H.temp(4), 'Callback', cmd1 );

	set( H.ok, 'Callback', cmd2 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, IM )

	H 	= Q_get_handles( parent );
	[ydim2,xdim2] = size( IM.im ); % defaults

	xdim	= round( str2num( get( H.temp(1), 'String' ) ) );
	if( isempty(xdim) ) xdim = xdim2; end;
	xdim	= max( xdim, 8 );
	xdim	= min( xdim, 1024 );
	set( H.temp(1), 'String', xdim );

	ydim	= round( str2num( get( H.temp(2), 'String' ) ) );
	if( isempty(ydim) ) ydim = ydim2; end;
	ydim	= max( ydim, 8 );
	ydim	= min( ydim, 1024 );
	set( H.temp(2), 'String', ydim );

	power	= str2num( get( H.temp(4), 'String' ) );
	if( isempty(power) ) power = 100; end;
	power	= max( power, 0 );
	power	= min( power, 100 );
	set( H.temp(4), 'String', power );

	vals 	= [xdim ydim power];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[ noise ] = make_noise( xdim, ydim, pow )

	noise	= pow/100 * rand( ydim, xdim );