%%%
%%% Q_SHOWCLIPPING: SHOW CLIPPED REGIONS OF IMAGE.
%%%
%%% 		Show an RGB image where red pixels denote values
%%% 		clipped above white, and blue pixels denote values
%%%		clipped below black. 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_showclipping( parent );

	if( Q_active(parent,1) )
		return;
	end

	Q_window( parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Show Clipping', 1, 0 );

	%%% MAKE COLOR IMAGE SHOWING CLIPPED REGIONS
	IM			= Q_get_iminfo( parent );
	index_under		= find( IM.im < IM.clim(1) );
	im_under		= zeros( size(IM.im) );
	im_under(index_under) 	= 1;
	index_over		= find( IM.im > IM.clim(2) );
	im_over			= zeros( size(IM.im) );
	im_over(index_over) 	= 1;
	im2(:,:,1)		= im_over;		% red channel
	im2(:,:,2)		= zeros( size(IM.im) );	% green channel
	im2(:,:,3)		= im_under;		% blue channel

	subplot( 'position', [0.5 0 0.5 1] );
	imagesc( im2 ); axis image; axis off;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
