%%%
%%% Q_SHOW_IM:	NON-MENU ROUTINE.
%%%
%%%		Display an image in figure(parent).  Set various
%%%		parameters to make things look nice.  Update menu
%%%		checkboxes for magnification and mode.  Update undo
%%%		buffer.  
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[] = Q_show_im( IM, parent );

	%%% OPEN FIGURE AND ADJUST SIZE	
	figure( parent );
	axHandle = gca;
	set_position( IM, parent );
	H 	= Q_get_handles( parent );

	%%% PLACE OLD DATA INTO UNDO BUFFER
	IM_UNDO	= Q_get_iminfo( parent );

	%%% BUILD FILENAME/MAGNIFY/RANGE STRING FOR TOP/BOTTOM OF FIGURE
	[ydim,xdim] 	= size( IM.im );
	minim		= min( IM.im(:) );
	maxim		= max( IM.im(:) );
	filename	= IM.filename( 1:min(10,size(IM.filename,2) ) );

	if( IM.magnify >= 1 )
		iminfo = sprintf( '[%dx]', IM.magnify );
	elseif( IM.magnify == 0.5 )
		iminfo = sprintf( '[1/2x]' );
	elseif( IM.magnify == 0.25 )
		iminfo = sprintf( '[1/4x]' );
	elseif( IM.magnify == 0.125 )
		iminfo = sprintf( '[1/8x]' );
	else
		iminfo = '';
	end
	iminfo = sprintf( '%s    [%d x %d]', iminfo, ydim,xdim );

	if( abs(maxim)>=1 & abs(IM.clim(2))>=1 )
	    iminfo = sprintf('%s    disp: [%.0f %.0f]    im: [%.0f %.0f]',...
			iminfo, IM.clim(1), IM.clim(2), minim, maxim );
	else
	    iminfo = sprintf('%s    disp: [%.2f %.2f]    im: [%.2f %.2f]',...
			iminfo, IM.clim(1), IM.clim(2), minim, maxim );
	end

	%%% SHOW IMAGE
	figure( parent );
	imagesc( IM.im );
	axis image;
	set( axHandle, 'XTick', [], 'YTick', [] );
	set( axHandle, 'Units', 'normalized', 'Position', [0 0 1 1] );
	caxis( IM.clim );
	colormap( Q_clip_cmap(IM.cmap) ); 

	%%% SET FIGURE NAME
	set( parent, 'Name', sprintf( '%d: %s', parent, IM.filename ) );
	set( H.iminfo, 'String', iminfo );

	%%% UPDATE MENU CHECK (MAGNIFY AND MODE)
	set( H.mode.gray, 'Checked', 'on' );

	set( H.display.magnify1_8x, 'Checked', 'off' );
	set( H.display.magnify1_4x, 'Checked', 'off' );
	set( H.display.magnify1_2x, 'Checked', 'off' );
	set( H.display.magnify1x, 'Checked', 'off' );
	set( H.display.magnify2x, 'Checked', 'off' );
	set( H.display.magnify4x, 'Checked', 'off' );
	set( H.display.magnify8x, 'Checked', 'off' );

        if( IM.magnify == 0.125 )
                set( H.display.magnify1_8x, 'Checked', 'on' );
        elseif( IM.magnify == 0.25 )
                set( H.display.magnify1_4x, 'Checked', 'on' );
        elseif( IM.magnify == 0.5 )
                set( H.display.magnify1_2x, 'Checked', 'on' );
        else
                eval(sprintf('set(H.display.magnify%dx,''Checked'',''on'');',...
			 	IM.magnify ) );
        end

	%%% UPDATE CURRENT AND UNDO DATA
	h = get( parent, 'UserData' );

	h.image.im		= IM.im;
	h.image.cmap		= IM.cmap;
	h.image.clim		= IM.clim;
	h.image.filename	= IM.filename;
	h.image.magnify		= IM.magnify;
	h.image.mode		= IM.mode;

	h.image.undo.im		= IM_UNDO.im;
	h.image.undo.cmap	= IM_UNDO.cmap;
	h.image.undo.clim	= IM_UNDO.clim;
	h.image.undo.filename	= IM_UNDO.filename;
	h.image.undo.magnify	= IM_UNDO.magnify;
	h.image.undo.mode	= IM_UNDO.mode;

	set( parent, 'UserData', h );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[] = set_position( IM, parent );

	set( parent, 'Units', 'pixels' );
	pos = get( parent, 'Position' );
	pos = [ max( 20, pos(1) ) ...
		max( 20, pos(2) - (IM.magnify*size(IM.im,1)-pos(4)) - 50 )...
		IM.magnify * size(IM.im,2) ...
		IM.magnify * size(IM.im,1) + 50 ];
	set( parent, 'Position', pos );
	set( parent, 'Units', 'normalized' );
