%%%
%%% Q_SHOW_HIST: NON-MENU ROUTINE.
%%%
%%%		Show histogram as a bar plot.  Pass in output of
%%%		Q_hist.m, and a position for the histogram to be
%%%		displayed.  Used to standardize the presentation of
%%%		histograms. 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_show_hist( parent, position, N, X, S );

	%%% SHOW HIST
	IM	= Q_get_iminfo( parent );
	figure( parent );
	subplot( 'position', position );
	bar( X, N, 1, 'b' );

	%%% ADJUST AXIS
	xlim(1)	= min( S.minval, min(IM.clim) );
	xlim(1) = xlim(1)-0.05*abs(xlim(1));
	xlim(2)	= max( S.maxval, max(IM.clim) );
	xlim(2) =  xlim(2)+0.05*abs(xlim(2));
	set( gca, 'XLim', xlim );
	set( gca, 'XTick', round(10*IM.clim)/10 );
	set( gca, 'YTick', round([0 max(N)]) );
	set( gca, 'XGrid', 'on' );
