%%%
%%% Q_SHAPREN: 	SHARPEN IMAGE.
%%%
%%%		Sharpen image by convolving image with a 3x3 highpass
%%%		filter: 
%%%			filt = 1/8 * [0 -1 0 ; -1 12 -1 ; 0 -1 0]; 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_sharpen( parent );

	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	filt	= Q_filters( 'sharpen' );
	IM.im	= Q_conv( IM.im, filt );
	Q_show_im( IM, parent );
	Q_active( parent, 0 );	