%%%
%%% Q_RESETFIG:	NON-MENU ROUTINE
%%%
%%%		Resize figure after Q_expandfig.m has been called.  If
%%%		an IM structure is passed, then update parent's image
%%%		with it, otherwise just resize and refresh display.
%%%		Remove all temporary handles created by menu option,
%%%		these will always be of the form H.temp(i) and will
%%%		exist only  if the number of handles is larger than
%%%		what is expected by the main menu handles. Finally,
%%%		unlock parent with a call to Q_active.m. 
%%%
%%% DATE: 	June 23, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[ ] = Q_resetfig( parent, IM )

	if( ~exist('IM') )
		IM = Q_get_iminfo( parent );
	end
	H	= Q_get_handles( parent );
	
	%%% REMOVE ALL TEMPORARY HANDLES AND OK/CANCEL MENUS
	if( size(fieldnames(H),1) > 11 )	% some temp handles exist
		N = size( H.temp, 2 );
		for i = 1 : N
			set( H.temp(i), 'Visible', 'off' );
		end
		H = rmfield( H, 'temp' );
	end

	set( H.ok, 'Visible', 'off' );
	set( H.cancel, 'Visible', 'off' );
	Q_set_handles( H, parent );

	%%% REFRESH DISPLAY
	subplot(1,1,1); axis off;
	Q_show_im( IM, parent );
	Q_active( parent, 0 );

	%%% RESET MOUSE MOTION FUNCTION
	set( parent, 'Pointer', 'crosshair' );
        set( parent, 'WindowButtonDownFcn', '' );
        set( parent, 'WindowButtonUpFcn', '' );
 	set( parent, 'WindowButtonMotionFcn', ...
		sprintf('Q_motionfcn( %d );', parent) );

	%%% CENTER ALIGN IMAGE INFORMATION
	set( H.iminfo, 'Position', [0.0 0.95 1 0.04] );
