%%%
%%% Q_RAMP: 	MAKE AN ORIENTED RAMP.
%%%
%%% 		Make an oriented linear ramp.  Control the dimensions
%%% 		of the ramp and the orientation.  Final image has
%%% 		values in the range [0,1].  
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_ramp( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	Q_window( parent );
	Q_sliders( parent, IM );
	Q_callbacks( parent );
	Q_ramp( str2num(sprintf('%d',parent)), 0, 1 );
else 
	if( mode == 1 ) % PREVIEW
		IM	= Q_get_iminfo( parent );
		vals	= Q_getvals( parent, IM );	
		s	= min( 1, 128 / max( vals(1), vals(2) ) );
		ramp	= make_ramp( s*vals(1), s*vals(2), vals(3) );
		Q_preview_im( ramp, parent, 0, gray(256), [0 1] );
	elseif( mode == 2 ) % OK
		IM	= Q_get_iminfo( parent );
		vals	= Q_getvals( parent, IM );	
		ramp	= make_ramp( vals(1), vals(2), vals(3) );
		Q_resetfig( parent, IM );
		Q_main( ramp, gray(256), [0 1], 1, 'gray', 'ramp' );
		return;
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Ramp', 1, 1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent, IM )

	H 		= Q_get_handles( parent );
	[ydim,xdim] 	= size( IM.im );
	orient		= 0;
	
	%%% XDIM/YDIM EDIT/LABEL 
	H.temp(1) = Q_input( parent, [0.72 0.37 0.1 0.06], xdim, 'edit' );
	H.temp(2) = Q_input( parent, [0.84 0.37 0.1 0.06], ydim, 'edit' );
	H.temp(3) = Q_input( parent, [0.5 0.37 0.2 0.06], 'X/Y size', 'text' );
	set( H.temp(3), 'FontSize', 12 );
	set( H.temp(3), 'HorizontalAlignment', 'right' );

	%%% RADIUS EDIT/LABEL
	H.temp(4) = Q_input( parent, [0.72 0.3 0.1 0.06], orient, 'edit' );
	H.temp(5) = Q_input( parent, [0.5 0.3 0.2 0.06], 'Orientation','text' );
	set( H.temp(5), 'FontSize', 12 );
	set( H.temp(5), 'HorizontalAlignment', 'right' );

	%%% RAMP ORIENTATION UNITS LABEL
	H.temp(6) = Q_input( parent, [0.84 0.3 0.1 0.06], '(deg)', 'text' );
	set( H.temp(6), 'FontSize', 12 );
	set( H.temp(6), 'HorizontalAlignment', 'left' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );
	cmd1 	= sprintf( 'Q_ramp(%d,0,1);', parent );
	cmd2 	= sprintf( 'Q_ramp(%d,0,2);', parent );

	%%% XDIM/YDIM/ORIENTATION
	set( H.temp(1), 'Callback', cmd1 );
	set( H.temp(2), 'Callback', cmd1 );
	set( H.temp(4), 'Callback', cmd1 );
	set( H.ok, 'Callback', cmd2 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, IM )

	H 	= Q_get_handles( parent );
	[ydim2,xdim2] = size( IM.im ); % defaults

	xdim	= round( str2num( get( H.temp(1), 'String' ) ) );
	if( isempty(xdim) ) xdim = xdim2; end;
	xdim	= max( xdim, 8 );
	xdim	= min( xdim, 1024 );
	set( H.temp(1), 'String', xdim );
	
	ydim	= round( str2num( get( H.temp(2), 'String' ) ) );
	if( isempty(ydim) ) ydim = ydim2; end;
	ydim	= max( ydim, 8 );
	ydim	= min( ydim, 1024 );
	set( H.temp(2), 'String', ydim );
	
	orient	= str2num( get( H.temp(4), 'String' ) );
	if( isempty(orient) ) orient = 0; end;
	orient	= max( orient, 0 );
	orient	= min( orient, 360 );
	set( H.temp(4), 'String', orient );
	 
	vals 	= [xdim ydim orient];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[ ramp ] = make_ramp( xdim, ydim, orient )

	[xramp,yramp]	= meshgrid( [1:xdim], [1:ydim] );
	orient		= orient * pi/180;
	ramp		= cos( orient )*xramp + sin( orient )*yramp;
	ramp		= ramp - min(ramp(:));
	ramp		= ramp / max(ramp(:));