%%%
%%% Q_QUANTIZE: QUANTIZE DISPLAY.
%%%
%%%		Quantize colormap into specified number of levels
%%%		ranging from 256 (full 8-bit) to 2 (binary).  Effects
%%%		display only. 
%%%
%%% DATE: 	July 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_quantize( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	IM2	= IM;
	IM2.im	= 255*Q_cmaplookup( IM.cmap, IM.clim, IM.im );
	[N,X,S]	= Q_hist( IM2 );
	Q_window( parent, IM, N, X, S );
	Q_sliders( parent );
	Q_callbacks( parent );
else
	IM	= Q_get_iminfo( parent );
	vals	= Q_getvals( parent, mode );
	q	= vals(1);		% quantization level

	%%% QUANTIZE COLORMAP AND UPDATE HISTOGRAM
	cmap2	= round( IM.cmap * (q-1) ) / (q-1);
	IM2	= IM;
	IM2.im	= 255*Q_cmaplookup( cmap2, IM.clim, IM.im );
	[N,X,S]	= Q_hist( IM2 );
	Q_show_hist( parent, [0.6 0.55 0.37 0.35], N, X, S );

	%%% CHECK IF DONE
	if( mode == 3 ) % OK
		IM.cmap = cmap2;
		Q_resetfig( parent, IM );
		return;
	end

	%%% UPDATE COLORMAP
	colormap( Q_clip_cmap( cmap2 ) );
end	

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent, IM, N, X, S )

	Q_expandfig( parent, 'Quantize/Contrast', 1, 1 );
	Q_show_hist( parent, [0.6 0.55 0.37 0.35], N, X, S );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent )

	H 		= Q_get_handles( parent );

	%%% SLIDER/EDIT/LABEL
	H.temp(1)	= Q_input( parent, [0.6 0.37 0.25 0.06], ...
				[2 256 256 2/256 10/256], 'slider' );
	H.temp(2)	= Q_input( parent, [0.86 0.37 0.12 0.06], 256, 'edit' );
	H.temp(3) 	= Q_input( parent, [0.86 0.30 0.12 0.06], ...
				'#Levels', 'text' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );
	cmd1 	= sprintf( 'Q_quantize(%d,0,1);', parent );
	cmd2 	= sprintf( 'Q_quantize(%d,0,2);', parent );
	cmd3 	= sprintf( 'Q_quantize(%d,0,3);', parent );

	%%% SLIDE/EDIT
	set( H.temp(1), 'Callback', cmd1 );
	set( H.temp(2), 'Callback', cmd2 );
	set( H.ok, 'Callback', cmd3 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, mode )

	H		= Q_get_handles( parent );

	if( mode == 1 | mode == 3 ) % SLIDER INPUT
		q	= round( get( H.temp(1), 'Value' ) );
		set( H.temp(2), 'String', q );
	elseif( mode == 2 ) 			% EDIT INPUT
		q	= round( str2num( get( H.temp(2), 'String' ) ) );
		q	= max( q, get( H.temp(1), 'Min' ) );
		q	= min( q, get( H.temp(1), 'Max' ) );
		if( isempty(q) ) q = 256;  end;
		set( H.temp(1), 'Value', q );
		set( H.temp(2), 'String', q );
	end
	vals 	= [ q ];