%%%
%%% Q_PREVIEW_IM: NON-MENU ROUTINE.
%%%
%%%		Show image in a small window of parent.  Default
%%%		position of window is in upper left corner of expanded
%%%		figure, optionally pass in a position.  If im=0, then
%%%		clear current image.  If cmap/clim are supplied, then
%%%		make an RGB image true to those parameters (need to
%%%		make it RGB so as to ignore figures own cmap/clim).
%%%		If cmap/clim are not supplied, then use figures
%%%		current settings.  Option to autoscale always exists.
%%%
%%% DATE: 	June 23, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_preview_im( im, parent, auto, cmap, clim, position );

	im	= double( im );
	IM	= Q_get_iminfo( parent );

	if( exist( 'position' ) == 1 )
		subplot( 'position', position )
	else
		subplot( 'position', [0.53 0.55 0.35 0.35] );
	end

	if( im == 0 ) 				% clear previous image
		cla; 	
		im2 = 0.5*ones(2,2,3) + eps;
		imagesc( im2 );
		axis image;
		set( gca, 'XTick', [], 'YTick', [] );
		return;
	elseif( ~exist('cmap') | cmap == -1)	% show image with cur. cmap/clim
		minim	= min( im(:) );
		maxim	= max( im(:) );
		if( auto )			% autoscale
			clim = [minim maxim];
		else
			clim = IM.clim;
		end
		im2	= im;
	else 					% show image with cmap/clim
		[ydim,xdim] = size(im);
		minim 	= min(im(:));
		maxim 	= max(im(:));
		if( auto )
			clim = [min(im(:)) max(im(:))];
		end
		im2(:,:,1) = Q_cmaplookup( cmap(:,1), clim, im );
		im2(:,:,2) = Q_cmaplookup( cmap(:,2), clim, im ); 
		im2(:,:,3) = Q_cmaplookup( cmap(:,3), clim, im );
		im2 	= max(im2,0);
		im2	= min(im2,1);
	end	
	imagesc( im2, clim ); 
	axis image;
	set( gca, 'XTick', [], 'YTick', [] );

	%%% TITLE SHOWING DISPLAY AND IMAGE RANGE
	if( abs(maxim)>=1 & abs(clim(2))>=1 )
		title( sprintf('disp: [%.0f %.0f]   im: [%.0f %.0f]',...
			clim(1), clim(2), minim, maxim ) );
	else
		title( sprintf('disp: [%.2f %.2f]   im: [%.2f %.2f]',...
			clim(1), clim(2), minim, maxim ) );
	end
