%%%
%%% Q_OPEN: 	READ IMAGE FROM DISK.
%%%
%%%		Load an image from disk into a new Q figure.
%%%		Currently supports file formats supported by built-in
%%%		matlab routine imread.m (BMP, HDF, JPEG, PCX, TIFF,
%%%		XWD).  Displays image with colormap/clim defined in
%%%		Q_defaults.m. 
%%%
%%% DATE: 	June 13, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_open( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	Q_window( parent );
	Q_sliders( parent );
	Q_callbacks( parent );
else
	if( mode == 1 ) % PREVIEW 
		vals	= Q_getvals( parent, mode );
		if( isempty( vals.name ) |  exist( vals.name ) ~= 2 )
			Q_preview_im( 0, parent );
			fprintf( 'Open(): file (%s) doesn''t exist\n', ...
				vals.name );
		else
			im = double( imread( vals.name ) );
			im = Q_make_preview_im( im );
			IM = Q_get_iminfo( parent );
			cmap = Q_defaults( 'cmap' );
			clim = Q_defaults( 'clim' );
			Q_preview_im( im, parent, vals.auto, cmap, clim );
		end
	elseif( mode == 2 ) % OK 
		vals	= Q_getvals( parent, mode );
		if( isempty( vals.name ) |  exist( vals.name ) ~= 2 )
			Q_preview_im( 0, parent );
			fprintf( 'Open(): file (%s) doesn''t exist\n',...
				vals.name);
		else
			im = double( imread( vals.name ) );
			IM = Q_get_iminfo( parent );
			D = Q_defaults( 'all' );
			Q_resetfig( parent, IM );
			if( vals.auto )
				D.clim = [min(im(:)) max(im(:))];
			end
			Q_main( im, D.cmap, D.clim, D.magnify, D.mode, ...
					vals.name );
		end
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Open', 1, 1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent )

	H		= Q_get_handles( parent );

	%%% FILENAME ENTRY
	H.temp(1)	= Q_input( parent, [0.6 0.38 0.35 0.1], ...
				'', 'edit' );
	set( H.temp(1), 'FontSize', 12 );
	set( H.temp(1), 'HorizontalAlignment', 'left' );

	%%% FILENAME LABEL
	H.temp(2) 	= Q_input( parent, [0.6 0.25 0.35 0.1], ...
				'File Name', 'text' );
	set( H.temp(2), 'FontSize', 12 );
	set( H.temp(2), 'HorizontalAlignment', 'left' );

	%%% AUTOSCALE OPTION
	H.temp(3) 	= Q_input( parent, [0.82 0.55 0.14 0.06], ...
				'Autoscale', 'checkbox' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H	= Q_get_handles( parent );
	cmd1	= sprintf( 'Q_open( %d,0,1 );', parent );
	cmd2	= sprintf( 'Q_open( %d,0,2 );', parent );

	set( H.temp(1), 'Callback', cmd1 );
	set( H.temp(3), 'Callback', cmd1 );
	set( H.ok, 'Callback', cmd2 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, mode )

	H	= Q_get_handles( parent );	
	vals.name	= get( H.temp(1), 'String' ); % filename
	vals.auto	= get( H.temp(3), 'Value' ); % autoscale option
