%%%
%%% Q_MOTIONFCN: NON-MENU ROUTINE.
%%%
%%%		Update current X/Y mouse position and display/image
%%%		value at that position.  This information is reported
%%%		at the bottom of the image.  This routine is set to
%%%		the figure 'WindowButtonMotionFcn'. 
%%%
%%% DATE: June 13, 1998
%%% BY:   Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%

function [] = Q_motionfcn( parent )

	IM	= Q_get_iminfo( parent );
	H	= Q_get_handles( parent );
	
	[x,y]	= Q_get_xy( parent );
	x	= round( x );
	y	= round( y );
	ival 	= IM.im( y, x );
	dval 	= round( 255*Q_cmaplookup( IM.cmap,IM.clim,IM.im(y,x) ) );

	set( H.pos, 'String', sprintf('X,Y: [%d, %d]',x,y) );	
	set( H.dval, 'String', sprintf('disp: [%d]',dval) );
	set( H.ival, 'String', sprintf('im: [%.2f]',ival) );
