%%%
%%% Q_MONTAGE:	CREATE A MONTAGE IMAGE.
%%%
%%%		Generate a new image that is a montage of all active Q
%%%		figures.  Each image is blurred, subsampled (by
%%%		Q_preview_im) and passed through its colormap before
%%%		being added to the montage.  Final image is set behind
%%%		a mid-level gray, with a 10 pixel spacing between
%%%		images.  
%%%
%%% DATE: 	July 13, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[] = Q_montage( parent )

	if( Q_active(parent,1) )
		return;
	end

	%%% FIND ALL Q FIGURES AMONG ALL CURRENT FIGURES
	figs	= get( 0, 'Children' );
	Qfigs	= [];
	N	= size(figs,1);
	c	= 1;
	for i = 1 : N
		tag = get( figs(i), 'Tag' );
		if( ~isempty(tag) )
			if( tag == 'Q' )
				Qfigs(c) = figs(i);
				c = c + 1;
			end
		end
	end

	%%% INITIALIZE MONTAGE IMAGE TO BE MID-LEVEL GRAY
	Qfigs 	= sort( Qfigs );
	N	= size( Qfigs, 2 );
	sp	= ceil( sqrt(N) );
	maxy 	= 0;
	maxx 	= 0;
	curx	= 0;
	cury	= 0;
	c	= 1;
	for y = 1 : sp
		for x = 1 : sp
			if( c > N ) 
				break; 
			end;
			IM = Q_get_iminfo( Qfigs(c) );
			im = Q_make_preview_im( IM.im );
			[ydim,xdim] = size( im );
			curx = curx + xdim + 1;
			if( x ~= sp )
				curx = curx + 10;
			end
			cury = max( cury, ydim );
			c = c + 1;
		end
		maxx = max( curx, maxx );
		maxy = cury + maxy + 10;
		curx = 0;
		cury = 0;
		if( c > N ) 
			break; 
		end;
	end
	D 	= Q_defaults( 'all' );
	bg	= mean( D.clim );
	montage	= bg * ones( maxy-10, maxx-1);


	%%% MAKE MONTAGE IMAGE
	c	= 1;
	curx	= 1;
	cury	= 1;
	maxy 	= -1;
	filt	= Q_filters( 'blur' );
	for y = 1 : sp
		for x = 1 : sp
			if( c > N ) 
				break; 
			end;
			IM = Q_get_iminfo( Qfigs(c) );
			im = Q_make_preview_im( IM.im );
	 		im = 255 * Q_cmaplookup( IM.cmap, IM.clim, im );
			im = Q_conv( im, filt );
			[ydim,xdim] = size( im );
			montage( cury:cury+ydim-1, curx:curx+xdim-1 ) = im;
			curx = curx + xdim + 1;
			if( x ~= sp )
				curx = curx + 10;
			end
			maxy = max( maxy, ydim ); 
			c = c + 1;
		end
		curx = 1;
		cury = cury + maxy + 10;
	end

	Q_main( montage, D.cmap, D.clim, D.magnify, D.mode, 'montage' ); 
	Q_active( parent, 0 );