%%%
%%% Q_MATLABSAVE: WRITE TO MATLAB WORKSPACE.
%%%
%%%		Write a Q image into the matlab workspace.  Image is
%%%		passed through colormap before writing, and written in
%%%		double format. 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_matlabsave( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	Q_window( parent );
	Q_sliders( parent );
	Q_callbacks( parent );
else 
	if( mode == 2 ) % OK 
		vals	= Q_getvals( parent, mode );
		if( isempty( vals ) )
			fprintf( 'Matlab Save(): no variable name\n' );
			return;
		else
			IM  = Q_get_iminfo( parent );
			im = 255*Q_cmaplookup( IM.cmap, IM.clim, IM.im );
			im = reshape( im, size(IM.im) );
				
			assignin( 'base', vals, im );
			Q_resetfig( parent, IM );
			return;
		end
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Matlab Save', 1, 1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent )

	H		= Q_get_handles( parent );
	IM		= Q_get_iminfo( parent );

	%%% FILENAME ENTRY
	H.temp(1)	= Q_input( parent, [0.6 0.38 0.35 0.1], ...
				IM.filename, 'edit' );
	set( H.temp(1), 'FontSize', 12 );
	set( H.temp(1), 'HorizontalAlignment', 'left' );

	%%% LABEL
	H.temp(2) 	= Q_input( parent, [0.6 0.25 0.35 0.1], ...
				'Variable Name', 'text' );
	set( H.temp(2), 'FontSize', 12 );
	set( H.temp(2), 'HorizontalAlignment', 'left' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H	= Q_get_handles( parent );
	cmd2	= sprintf( 'Q_matlabsave( %d,0,2 );', parent );

	set( H.ok, 'Callback', cmd2 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, mode )

	H	= Q_get_handles( parent );	
	vals	= get( H.temp(1), 'String' );