%%%
%%% Q_MAKE_PREVIEW_IM: NON-MENU ROUTINE.
%%%
%%%		Return a subsampled copy of the image passed in.
%%%		Maximum dimension of subsampled image is 128 pixels.
%%%		No blurring before subsampling, so expect aliasing
%%%		artifacts. 
%%%		
%%%		This is used for fast previewing of intermediate
%%%		results while interactively changing a slider, for
%%%		example.  
%%%
%%% DATE: 	June 23, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [im2] = Q_make_preview_im( im );

	[ydim,xdim] = size( im );
	s	= max( xdim,ydim )/128;
	s	= max( s, 1 );
	s	= round( s );
	im2	= im( 1:s:ydim, 1:s:xdim );