%%%
%%% Q_MAIN: 	NON-MENU ROUTINE.
%%%
%%%		Create or update a Q figure.  When passed with a
%%%		figure number (parent), if that figure already exists
%%%		replace current image, otherwise create a new figure
%%%		and insert new image.  When creating a new Q figure,
%%%		setup up menus and callback. 
%%%
%%%		NOTE: Not to be called directly, use Q.m instead.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [fig] = Q_main( im, cmap, clim, magnify, mode, filename, parent )

im 	= double( im );

if( exist('parent')==1 )
	fig	= figure( parent );
else
	fig 	= figure;
end

if( ~isempty( get(fig,'UserData') ) ) 	% UPDATE IMAGE IN EXISTING FIGURE

   IM 		= Q_get_iminfo( fig );
   IM.im	= im;
   IM.cmap	= cmap;
   IM.clim	= clim;
   IM.filename	= filename;
   IM.magnify	= magnify;
   IM.mode	= mode;
   Q_show_im( IM, fig );

else 					% CREATE NEW FIGURE WITH MENUS

   %%% ----------------------------------------------------------------
   %%% SETUP MAIN MENUS
   % -----
   mh.file.main		= uimenu(fig, 'Label', 'File');
   mh.edit.main		= uimenu(fig, 'Label', 'Edit');
   mh.mode.main		= uimenu(fig, 'Label', 'Mode');
   mh.display.main 	= uimenu(fig, 'Label', 'Display');
   mh.image.main 	= uimenu(fig, 'Label', 'Image');
 
   % ----- FILE -----
   mh.file.about	= uimenu( mh.file.main, 'Label', 'About...');
   mh.file.new		= uimenu( mh.file.main, 'Label', 'New');
			set( mh.file.new, 'Separator', 'on');
   mh.file.open		= uimenu( mh.file.main, 'Label', 'Open...');
   mh.file.save		= uimenu( mh.file.main, 'Label', 'Save...');
   mh.file.matlabcmd	= uimenu( mh.file.main, 'Label', 'Matlab Cmd...');
			set( mh.file.matlabcmd, 'Separator', 'on');
   mh.file.matlabopen	= uimenu( mh.file.main, 'Label', 'Matlab Open...');
   mh.file.matlabsave	= uimenu( mh.file.main, 'Label', 'Matlab Save...');
   mh.file.close	= uimenu( mh.file.main, 'Label', 'Close');
			set( mh.file.close, 'Separator', 'on');
		
   % ----- EDIT -----
   mh.edit.crop		= uimenu( mh.edit.main, 'Label', 'Crop');
   mh.edit.duplicate	= uimenu( mh.edit.main, 'Label', 'Duplicate');
   mh.edit.montage	= uimenu( mh.edit.main, 'Label', 'Montage');
   mh.edit.undo		= uimenu( mh.edit.main, 'Label', 'Undo');

   % ----- MODE -----
   mh.mode.gray		= uimenu( mh.mode.main, 'Label', 'Grayscale');

   % ----- DISPLAY -----
   mh.display.histogram	= uimenu( mh.display.main, 'Label', 'Histogram');
   mh.display.adjust	= uimenu( mh.display.main, 'Label', 'Adjust');
			set( mh.display.adjust, 'Separator', 'on');
   mh.display.bright	= uimenu( mh.display.adjust, 'Label', ...
				'Brightness/Contrast...');
   mh.display.levels	= uimenu( mh.display.adjust, 'Label', 'Levels...');
   mh.display.quantize	= uimenu( mh.display.adjust, 'Label', 'Quantize...');
   mh.display.map	= uimenu( mh.display.main, 'Label', 'Map');
   mh.display.autoscale	= uimenu( mh.display.map, 'Label', 'Autoscale');
   mh.display.equalize	= uimenu( mh.display.map, 'Label', 'Equalize');
   mh.display.invert	= uimenu( mh.display.map, 'Label', 'Invert');
   mh.display.linearize	= uimenu( mh.display.map, 'Label', 'Linearize');
   mh.display.lineprofile = uimenu( mh.display.main, 'Label', ...
				'Line Profile...' );
			set( mh.display.lineprofile, 'Separator', 'on');
   mh.display.look	= uimenu( mh.display.main, 'Label', 'Look...');
   mh.display.showclipping= uimenu( mh.display.main, 'Label', ...
				'Show Clipping...');
   mh.display.magnify	= uimenu( mh.display.main, 'Label', 'Magnify');
			set( mh.display.magnify, 'Separator', 'on');
   mh.display.magnify1_8x= uimenu( mh.display.magnify, 'Label', '1/8x');
   mh.display.magnify1_4x= uimenu( mh.display.magnify, 'Label', '1/4x');
   mh.display.magnify1_2x= uimenu( mh.display.magnify, 'Label', '1/2x');
   mh.display.magnify1x	= uimenu( mh.display.magnify, 'Label', '1x');
   mh.display.magnify2x	= uimenu( mh.display.magnify, 'Label', '2x');
   mh.display.magnify4x	= uimenu( mh.display.magnify, 'Label', '4x');
   mh.display.magnify8x	= uimenu( mh.display.magnify, 'Label', '8x');
   mh.display.refresh	= uimenu( mh.display.main, 'Label', 'Refresh');

   % ----- IMAGE -----
   mh.image.histogram	= uimenu( mh.image.main, 'Label', 'Histogram');
   mh.image.filter	= uimenu( mh.image.main, 'Label', 'Filter');
			set( mh.image.filter, 'Separator', 'on');
   mh.image.addnoise	= uimenu( mh.image.filter, 'Label', 'Add Noise...');
   mh.image.arbitrary	= uimenu( mh.image.filter, 'Label', 'Aribtrary...');
   mh.image.blur	= uimenu( mh.image.filter, 'Label', 'Blur');
   mh.image.gaussianblur= uimenu( mh.image.filter, 'Label', ...
				'Gaussian Blur...');
   mh.image.gradient	= uimenu( mh.image.filter, 'Label', 'Gradient');
   mh.image.sharpen	= uimenu( mh.image.filter, 'Label', 'Sharpen');
   mh.image.transform	= uimenu( mh.image.main, 'Label', 'Transform');
   mh.image.fourier	= uimenu( mh.image.transform, 'Label', 'Fourier...' );
   mh.image.rectpolar	= uimenu( mh.image.transform, 'Label', ...
				'Rect <-> Polar...' );

   mh.image.rotfree	= uimenu( mh.image.transform, 'Label','Rotate Free...');
			set( mh.image.rotfree, 'Separator', 'on');
   mh.image.rot180	= uimenu( mh.image.transform, 'Label', 'Rotate 180');
   mh.image.rot90cw	= uimenu( mh.image.transform, 'Label', 'Rotate 90 cw');
   mh.image.rot90ccw	= uimenu( mh.image.transform, 'Label', 'Rotate 90 ccw');
   mh.image.fliphor	= uimenu( mh.image.transform, 'Label', ...
				'Flip Horizontal');
   mh.image.flipver	= uimenu( mh.image.transform, 'Label', ...
				'Flip Vertical');
			set( mh.image.fliphor, 'Separator', 'on');
   mh.image.render	= uimenu( mh.image.main, 'Label', 'Render');
			set( mh.image.render, 'Separator', 'on');
   mh.image.disc	= uimenu( mh.image.render, 'Label', 'Disc...');
   mh.image.fractal	= uimenu( mh.image.render, 'Label', 'Fractal...');
   mh.image.gaussian	= uimenu( mh.image.render, 'Label', 'Gaussian...');
   mh.image.ramp	= uimenu( mh.image.render, 'Label', 'Ramp...');
   mh.image.sinusoid	= uimenu( mh.image.render, 'Label', 'Sinusoid...');
   mh.image.squarewave	= uimenu( mh.image.render, 'Label', 'Square Wave...');
   mh.image.whitenoise	= uimenu( mh.image.render, 'Label','White Noise...');
   mh.image.zoneplate	= uimenu( mh.image.render, 'Label', 'Zone Plate...');

   %%% ----------------------------------------------------------------
   %%% DEFINE CALLBACKS FOR MENUS

   % ----- FILE -----
   set( mh.file.about, 'Callback', 'Q_about(gcf);' );
   set( mh.file.new, 'Callback', 'Q_new(gcf);' );
   set( mh.file.open, 'Callback', 'Q_open(gcf,1);' );
   set( mh.file.close, 'Callback', 'Q_close(gcf);' );
   set( mh.file.save, 'Callback', 'Q_save(gcf,1);' );
   set( mh.file.matlabcmd, 'Callback', 'Q_matlabcmd(gcf,1);' );
   set( mh.file.matlabopen, 'Callback', 'Q_matlabopen(gcf,1);' );
   set( mh.file.matlabsave, 'Callback', 'Q_matlabsave(gcf,1);' );

   % ----- EDIT -----
   set( mh.edit.crop, 'Callback', 'Q_crop(gcf);' );
   set( mh.edit.duplicate, 'Callback', 'Q_duplicate(gcf);' );
   set( mh.edit.montage, 'Callback', 'Q_montage(gcf);' );
   set( mh.edit.undo, 'Callback', 'Q_undo(gcf);' );

   % ----- MODE -----

   % ----- DISPLAY -----
   set( mh.display.histogram, 'Callback', 'Q_histogram(gcf,1,1);' );
   set( mh.display.bright, 'Callback', 'Q_brightness(gcf,1);' );
   set( mh.display.levels, 'Callback', 'Q_levels(gcf,1);' );
   set( mh.display.quantize, 'Callback', 'Q_quantize(gcf,1);' );
   set( mh.display.autoscale, 'Callback', 'Q_autoscale(gcf);' );
   set( mh.display.equalize, 'Callback', 'Q_equalize(gcf);' );
   set( mh.display.invert, 'Callback', 'Q_invert(gcf);' );
   set( mh.display.linearize, 'Callback', 'Q_linearize(gcf);' );
   set( mh.display.lineprofile, 'Callback', 'Q_line_profile(gcf,1);' );
   set( mh.display.look, 'Callback', 'Q_look(gcf,1);' );
   set( mh.display.showclipping, 'Callback', 'Q_showclipping(gcf);' );
   set( mh.display.magnify1_8x, 'Callback', 'Q_magnify(gcf,0.125);' );
   set( mh.display.magnify1_4x, 'Callback', 'Q_magnify(gcf,0.25);' );
   set( mh.display.magnify1_2x, 'Callback', 'Q_magnify(gcf,0.5);' );
   set( mh.display.magnify1x, 'Callback', 'Q_magnify(gcf,1);' );
   set( mh.display.magnify2x, 'Callback', 'Q_magnify(gcf,2);' );
   set( mh.display.magnify4x, 'Callback', 'Q_magnify(gcf,4);' );
   set( mh.display.magnify8x, 'Callback', 'Q_magnify(gcf,8);' );
   set( mh.display.refresh, 'Callback', 'Q_refresh(gcf);' );

   % ----- IMAGE -----
   set( mh.image.histogram, 'Callback', 'Q_histogram(gcf,1,2);' );
   set( mh.image.addnoise, 'Callback', 'Q_addnoise(gcf,1);' );
   set( mh.image.arbitrary, 'Callback', 'Q_filter_arbitrary(gcf,1);' );
   set( mh.image.blur, 'Callback', 'Q_blur(gcf);' );
   set( mh.image.gaussianblur, 'Callback', 'Q_gaussianblur(gcf,1);' );
   set( mh.image.gradient, 'Callback', 'Q_gradient(gcf);' );
   set( mh.image.sharpen, 'Callback', 'Q_sharpen(gcf);' );
   set( mh.image.fourier, 'Callback', 'Q_fourier(gcf,1);' );
   set( mh.image.rectpolar, 'Callback', 'Q_rectpolar(gcf,1);' );
   set( mh.image.rotfree, 'Callback', 'Q_rotatefree(gcf,1);' );
   set( mh.image.rot180, 'Callback', 'Q_rotate90(gcf,2);' );
   set( mh.image.rot90cw, 'Callback', 'Q_rotate90(gcf,-1);' );
   set( mh.image.rot90ccw, 'Callback', 'Q_rotate90(gcf,1);' );
   set( mh.image.fliphor, 'Callback', 'Q_flip(gcf,1);' );
   set( mh.image.flipver, 'Callback', 'Q_flip(gcf,0);' );
   set( mh.image.disc, 'Callback', 'Q_disc(gcf,1);' );
   set( mh.image.fractal, 'Callback', 'Q_fractal(gcf,1);' );
   set( mh.image.gaussian, 'Callback', 'Q_gaussian(gcf,1);' );
   set( mh.image.ramp, 'Callback', 'Q_ramp(gcf,1);' );
   set( mh.image.sinusoid, 'Callback', 'Q_sinusoid(gcf,1);' );
   set( mh.image.squarewave, 'Callback', 'Q_squarewave(gcf,1);' );
   set( mh.image.whitenoise, 'Callback', 'Q_whitenoise(gcf,1);' );
   set( mh.image.zoneplate, 'Callback', 'Q_zoneplate(gcf,1);' );

   %%% ----------------------------------------------------------------
   %%% SETUP IMAGE INFO SLIDERS
   mh.iminfo	= Q_input( fig, [0.0 0.95 1 0.04], '-', 'text' );

   %%% ----------------------------------------------------------------
   %%% SETUP MOUSE MOTION CALLBACKS
   set( fig, 'Pointer', 'crosshair' );

   mh.pos	= Q_input( fig, [0.0 0.0 0.4 0.04], '-', 'text' );
   mh.dval	= Q_input( fig, [0.4 0.0 0.25 0.04], '-', 'text' );
   mh.ival	= Q_input( fig, [0.65 0.0 0.25 0.04], '-', 'text' );
   set( fig, 'WindowButtonMotionFcn',  sprintf('Q_motionfcn( %d );', fig) );

   %%% ----------------------------------------------------------------
   %%% BUILD IMAGE DATA STRUCTURE
   ih 		= get( fig, 'UserData' );

   ih.im	= im;
   ih.cmap	= cmap;
   ih.clim	= clim;
   ih.filename	= filename;
   ih.magnify	= magnify;
   ih.mode	= mode;

   ih.undo.im	= ih.im;
   ih.undo.cmap	= ih.cmap;
   ih.undo.clim	= ih.clim;
   ih.undo.filename= ih.filename;
   ih.undo.magnify= ih.magnify;
   ih.undo.mode	= ih.mode;

   %%% ----------------------------------------------------------------
   %%% ASSIGN USERDATA TO FIGURE AND DISPLAY
   Q.image	= ih;
   Q.handles	= mh;
   Q.active	= 0;
   set( fig, 'UserData', Q );

   IM		= Q_get_iminfo( fig );
   Q_show_im( IM, fig );


   %%% ----------------------------------------------------------------
   %%% SET VARIOUS FIGURE OPTIONS
   set( fig, 'Resize', 'on' );
   set( fig, 'Renderer', 'zbuffer' );
   set( fig, 'NextPlot', 'add' );
   set( fig, 'Units', 'normalized' );
   set( fig, 'MenuBar', 'none' ) ;
   set( fig, 'NumberTitle', 'off' );
   set( fig, 'Tag', 'Q' );
end

