%%%
%%% Q_MAGNIFY:	SHRINK/ENLARGE FIGURE.
%%%
%%%		Control the magnification of the image in integer
%%%		increments, 1/8, 1/4, 1/2, 1, 2, 4, 8 X.  Show
%%%		magnification next to figure name on top of image. 
%%%		
%%%		NOTE: Figure can't be made arbitrarily small, Matlab
%%%		forces a minimum size in order to display menus -
%%%		magnify doesn't know about this, so displayed
%%%		magnification may not be true magnification. 
%%%
%%% DATE: 	June 13, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[] = Q_magnify( parent, m );

	if( Q_active(parent,1) )
		return;
	end

	IM = Q_get_iminfo( parent );
	IM.magnify = m;
	Q_show_im( IM, parent );
	Q_active( parent, 0 );
