%%%
%%% Q_LOOK:	LOOK AT PIXEL VALUES.
%%%
%%%		Show pixel values in a 5 x 5 neighborhood.  Update as
%%%		mouse moves across the image.  Shown are the
%%%		displayed pixel values (i.e., image pixel values
%%%		passed through colormap.). 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[] = Q_look( parent, first, mode )

if( first )
	if( Q_active(parent,1) )
		return;
	end

	Q_window( parent );
	Q_sliders( parent );
	Q_callbacks( parent );
else
	%%% CHECK IF DONE
	if( mode == 2 ) 
		set( parent, 'WindowButtonMotionFcn', '' );
		IM	= Q_get_iminfo( parent );
		Q_resetfig( parent, IM );
		return;
	end

	%%% DETERMINE X/Y POSITION - DIFFERENT FROM Q_GET_XY BECAUSE OF
	%%% 	ENLARGED WINDOW.
	set( parent, 'Units', 'pixels' );
	H		= Q_get_handles( parent );
	IM		= Q_get_iminfo( parent );
	[ydim,xdim] 	= size(IM.im);
	fig_pos		= get( parent, 'Position' );
	im_dims		= [2*xdim ydim]; % flip x/y
	fig_dims	= [fig_pos(3) fig_pos(4)];
	scale		= im_dims ./ fig_dims;
	offset		= fig_dims - im_dims./max(scale);
	scale		= im_dims ./ (fig_dims-offset);
	mouse_pos	= get( parent, 'CurrentPoint' );
	x		= mouse_pos(1) + 1;
	x		= scale(1) * (x - offset(1)/4);
	y		= fig_dims(2) - mouse_pos(2) + 1;
	y		= scale(2) * (y - offset(2)/2);
	x		= round( max( min(x,xdim-2), 3 ) );
	y		= round( max( min(y,ydim-2), 3 ) );

	im		= IM.im( y-2:y+2, x-2:x+2 );	
	im		= round( 255*Q_cmaplookup( IM.cmap, IM.clim, im ) );
	set( H.temp(2), 'String', sprintf( '[%d, %d]', x,y ) );
	set( H.temp(3), 'String', sprintf( '%-8d %-8d %-8d %-8d %-8d\n', im') );
	set( parent, 'Units', 'normalized' );
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Look', 1, 0 );
	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent )

	H 	= Q_get_handles( parent );
	
	%%% X/Y LABEL AND VALUE 
	H.temp(1)  = Q_input( parent, [0.55 0.3 0.07 0.05], 'X,Y: ', 'text' );
        H.temp(2)  = Q_input( parent, [0.62 0.3 0.2 0.05], '-', 'text' );
	set( H.temp(1), 'FontSize', 12 );
	set( H.temp(2), 'FontSize', 12 );
	set( H.temp(2), 'HorizontalAlignment', 'left' );

	%%% IMAGE VALUES
	H.temp(3)  = Q_input( parent, [0.55 0.35 0.45 0.45], '', 'text' );
	set( H.temp(3), 'FontSize', 12 );
	set( H.temp(3), 'HorizontalAlignment', 'left' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );

	cmd1 	= sprintf( 'Q_look(%d,0,1);', parent );
	cmd2 	= sprintf( 'Q_look(%d,0,2);', parent );
	
	set( parent, 'WindowButtonMotionFcn', cmd1 );
	set( H.ok, 'Callback', cmd2 );
