%%%
%%% Q_LINEARIZE: LINEARIZE COLORMAP.
%%%
%%%		Replace current colormap with linear gray colormap.
%%%		Leaves colormap axis untouched.  Useful for restoring
%%%		colormap after, for example, Q_quantize.m or
%%%		Q_equalize.m.
%%%
%%% DATE: 	June 13, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_linearize( parent );
	
	if( Q_active(parent,1) )
		return;
	end

	IM		= Q_get_iminfo( parent );
	IM.cmap		= gray( 256 );
	Q_show_im( IM, parent );
	Q_active( parent, 0 );