%%%
%%% Q_LEVELS:	ADJUST DISPLAY RANGE.
%%%
%%%		Adjust the input and output range of the colormap.
%%%		For example adjust the min and max pixel values that
%%%		are mapped to black and white. Only effects display of
%%%		image. 
%%%		
%%%		NOTE: middle sliders are not yet functional.  
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_levels( parent, first, mode, ax );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	AX	= get( parent, 'CurrentAxes' );
	IM	= Q_get_iminfo( parent );
	[N,X,S]	= Q_hist( IM );
	Q_window( parent, IM, N, X, S );
	Q_sliders( parent, IM, S );
	Q_callbacks( parent, AX );
else 
	IM	= Q_get_iminfo( parent );
	vals	= Q_getvals( parent, mode );	
	in1	= vals(1); in2 = vals(2); in3 = vals(3);
	out1	= vals(4); out2 = vals(5); out3 = vals(6);
	if( in1 == in3 )
		in3 = in3 + 1e-5;
	end
	if( out1 == out3 )
		out3 = out3 + 1e-5;
	end
	m	= 255*(out3-out1) / (in3-in1);
	b	= 255*out3 - m*in3;
	clim2	= [(-b/m) ((255-b)/m)];
	cmap2	= IM.cmap;

	%%% ADJUST COLORMAP AND CAXIS
	sign1	= sign( cmap2(256,1) - cmap2(1,1) );
	sign2	= sign( clim2(2) - clim2(1) );
	if( clim2(2) < clim2(1) )
		clim2	= [clim2(2) clim2(1)];
	end		
	if( clim2(1) == clim2(2) )
		clim2	= [clim2(1) clim2(2)+1e-5];
	end
	if( sign1 ~= sign2 )
		cmap2	= 1-cmap2;
	end

	%%% CHECK IF DONE
	if( mode(1) == 3 ) % OK
		IM.clim = clim2;
		IM.cmap	= cmap2;
		Q_resetfig( parent, IM );
		return;
	end

	%%% UPDATE HISTOGRAM AXIS
	xlim(1)	= min( min(IM.im(:)), min(clim2) );
	xlim(1) = xlim(1)-0.05*abs(xlim(1));
	xlim(2)	= max( max(IM.im(:)), max(clim2) );
	xlim(2) = xlim(2)+0.05*abs(xlim(2));
	clim3	= round(clim2*10)/10;
	clim3(1)= clim3(1) - 1e-5;
	set( vals(7), 'XLim', xlim );
 	set( vals(7), 'XTick', clim3 );

	%%% UPDATE COLORMAP AND CAXIS
	colormap( Q_clip_cmap(cmap2) );
	set( ax, 'Clim', clim2 );
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent, IM, N, X, S )

	Q_expandfig( parent, 'Levels', 1, 1 );
	Q_show_hist( parent, [0.6 0.55 0.37 0.35], N, X, S );

	subplot( 'position', [0.6 0.21 0.25 0.07] );
	scale		= ones( 10, 256, 3 );
	scale(:,:,1)	= ones(10,1) * [0:255]/255;
	scale(:,:,2)	= ones(10,1) * [0:255]/255;
	scale(:,:,3)	= ones(10,1) * [0:255]/255;
	imagesc( scale );	% color image not effected by colormap changes
	set( gca, 'XTick', [], 'YTick', [] );
	axis image;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent, IM, S )

	H 	= Q_get_handles( parent );

	L1      = min( S.minval, IM.clim(1) );		% input range
	L3      = max( S.maxval, IM.clim(2) );  
	L1a	= IM.clim(1); 
	L3a	= IM.clim(2); 
	L2a	= round( mean( [L1a L3a] )* 100 ) / 100;

	L4a	= round( 100*IM.cmap(1,1) )/100;	% output range
	L6a	= round( 100*IM.cmap(256,1) )/100;
	if( L4a < 0 ) L4a = 0; end;
	if( L4a > 1 ) L4a = 1; end;
	if( L6a < 0 ) L6a = 0; end;
	if( L6a > 1 ) L6a = 1; end;
	L5a	= round( 100*mean([L4a L6a]) )/100;

	%%% INPUT TOP SLIDER/EDIT
	H.temp(1)	= Q_input( parent, [0.6 0.43 0.25 0.05], ...
			[L1 L3 L1a 0.01 0.1],'slider' );
	H.temp(2)	= Q_input( parent, [0.86 0.43 0.12 0.06], ...
			L1a, 'edit' );
	%%% INPUT MID SLIDER/EDIT
	H.temp(3)	= Q_input( parent, [0.6 0.38 0.25 0.05], ...
			[L1 L3 L2a 0.01 0.1], 'slider' );
	H.temp(4)	= Q_input( parent, [0.86 0.38 0.12 0.06], ...
			L2a, 'edit' );
	%%% INPUT BOTTOM SLIDER/EDIT
	H.temp(5)	= Q_input( parent, [0.6 0.33 0.25 0.05], ...
			[L1 L3 L3a 0.01 0.1], 'slider' );
	H.temp(6)	= Q_input( parent, [0.86 0.33 0.12 0.06], ...
			L3a, 'edit' );

	%%% OUTPUT TOP SLIDER/EDIT
	H.temp(7)	= Q_input( parent, [0.6 0.17 0.25 0.05], ...
				[0 1 L4a 0.01 0.1], 'slider' );
	H.temp(8)	= Q_input( parent, [0.86 0.17 0.12 0.06], ...
				L4a, 'edit' );
	%%% OUTPUT MID SLIDER/EDIT
	H.temp(9)	= Q_input( parent, [0.6 0.12 0.25 0.05], ...
				[0 1 L5a 0.01 0.1], 'slider' );
	H.temp(10)	= Q_input( parent, [0.86 0.12 0.12 0.06], ...
				L5a, 'edit' );
	%%% OUTPUT BOTTOM SLIDER/EDIT
	H.temp(11)	= Q_input( parent, [0.6 0.07 0.25 0.05], ...
				[0 1 L6a 0.01 0.1], 'slider' );
	H.temp(12)	= Q_input( parent, [0.86 0.07 0.12 0.06], ...
				L6a, 'edit' );

	%%% INPUTE/OUTPUT LABELS
	H.temp(13)	= Q_input( parent, [0.86 0.27 0.12 0.06], ...
				'Input', 'text' );
	H.temp(14)	= Q_input( parent, [0.86 0.01 0.12 0.06], ...
				'Output', 'text' );

	subplot( 'position', [0.6 0.55 0.37 0.35] );
	H.temp(15) 	= get( parent, 'CurrentAxes' );
	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent, ax )
	
	H 	= Q_get_handles( parent );
	cmd1	= sprintf( 'Q_levels(%d,0,[1 1],%.20f);', parent, ax );
	cmd2	= sprintf( 'Q_levels(%d,0,[2 1],%.20f);', parent, ax );
	cmd3	= sprintf( 'Q_levels(%d,0,[1 2],%.20f);', parent, ax );
	cmd4	= sprintf( 'Q_levels(%d,0,[2 2],%.20f);', parent, ax );
	cmd5	= sprintf( 'Q_levels(%d,0,[1 3],%.20f);', parent, ax );
	cmd6	= sprintf( 'Q_levels(%d,0,[2 3],%.20f);', parent, ax );
	cmd7	= sprintf( 'Q_levels(%d,0,[1 4],%.20f);', parent, ax );
	cmd8	= sprintf( 'Q_levels(%d,0,[2 4],%.20f);', parent, ax );
	cmd9	= sprintf( 'Q_levels(%d,0,[1 5],%.20f);', parent, ax );
	cmd10	= sprintf( 'Q_levels(%d,0,[2 5],%.20f);', parent, ax );
	cmd11	= sprintf( 'Q_levels(%d,0,[1 6],%.20f);', parent, ax );
	cmd12	= sprintf( 'Q_levels(%d,0,[2 6],%.20f);', parent, ax );
	cmd13	= sprintf( 'Q_levels(%d,0,[3 -1],%.20f);', parent, ax );

	for i = 1 : 12
		eval( sprintf('set( H.temp(%d), ''Callback'', cmd%d );',i,i) );
	end

	set( H.ok, 'Callback', cmd13 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, mode )

	H 	= Q_get_handles( parent );

	if( mode(1) == 1 | mode(1) == 3 | mode(1) == 4 ) % SLIDER INPUT
		in1	= round( 100* get( H.temp(1), 'Value' ) ) / 100;
		in2	= round( 100*get( H.temp(3), 'Value' ) ) / 100;
		in3	= round( 100*get( H.temp(5), 'Value' ) ) / 100;
		out1	= round( 100*get( H.temp(7), 'Value' ) ) / 100;
		out2	= round( 100*get( H.temp(9), 'Value' ) ) / 100;
		out3	= round( 100*get( H.temp(11), 'Value' ) ) / 100;
		set( H.temp(2), 'String', in1 );
		if( mode(2) == 2 ) % ADJUST MIDDLE SLIDER
			if( in2<in1 & in2<in3 ) 
				in2 = min( in1, in3 );
			elseif( in2>in1 & in2>in3 )
				in2 = max( in1, in3 );		
			end
			set( H.temp(3), 'Value', in2 );
			set( H.temp(4), 'String', in2 );
		end
		if( mode(2) == 1  | mode(2) == 3 )
			set( H.temp(3), 'Value', ...
				round(100*mean([in1 in3]))/100 );
			set( H.temp(4), 'String', ...
				round(100*mean([in1 in3]))/100 );
		end
		set( H.temp(6), 'String', in3 );

		set( H.temp(8), 'String', out1 );
		if( mode(2) == 5 ) % ADJUST MIDDLE SLIDER
			if( out2<out1 & out2<out3 ) 
				out2 = min( out1, out3 );
			elseif( out2>out1 & out2>out3 )
				out2 = max( out1, out3 );		
			end
			set( H.temp(9), 'Value', out2 );
			set( H.temp(10), 'String', out2 );
		end
		if( mode(2) == 4  | mode(2) == 6 )
			set( H.temp(9), 'Value', ...
				round(100*mean([out1 out3]))/100 );
			set( H.temp(10), 'String', ...
				round(100*mean([out1 out3]))/100 );
		end
		set( H.temp(12), 'String', out3 );
	elseif( mode(1) == 2 ) % EDIT INPUT
		in1	= str2num( get( H.temp(2), 'String' ) );
		if( isempty( in1 ) ) in1 = get( H.temp(1), 'Value'  ); end;
		in1	= max( in1, get( H.temp(1), 'Min' ) );
		in1	= min( in1, get( H.temp(1), 'Max' ) );
		in2	= str2num( get( H.temp(4), 'String' ) );
		if( isempty( in2 ) ) in2 = get( H.temp(3), 'Value'  ); end;
		in2	= max( in2, get( H.temp(3), 'Min' ) );
		in2	= min( in2, get( H.temp(3), 'Max' ) );
		in3	= str2num( get( H.temp(6), 'String' ) );
		if( isempty( in3 ) ) in3 = get( H.temp(5), 'Value'  ); end;
		in3	= max( in3, get( H.temp(5), 'Min' ) );
		in3	= min( in3, get( H.temp(5), 'Max' ) );
		out1	= str2num( get( H.temp(8), 'String' ) );
		if( isempty( out1 ) ) out1 = get( H.temp(7), 'Value'  ); end;
		out1	= max( out1, get( H.temp(7), 'Min' ) );
		out1	= min( out1, get( H.temp(7), 'Max' ) );
		out2	= str2num( get( H.temp(10), 'String' ) );
		if( isempty( out2 ) ) out2 = get( H.temp(9), 'Value'  ); end;
		out2	= max( out2, get( H.temp(9), 'Min' ) );
		out2	= min( out2, get( H.temp(9), 'Max' ) );
		out3	= str2num( get( H.temp(12), 'String' ) );
		if( isempty( out3 ) ) out3 = get( H.temp(11), 'Value'  ); end;
		out3	= max( out3, get( H.temp(11), 'Min' ) );
		out3	= min( out3, get( H.temp(11), 'Max' ) );
		set( H.temp(1), 'Value', in1 );
		set( H.temp(2), 'String', in1 );
		if( mode(2) == 2 ) % ADJUST MIDDLE SLIDER
			if( in2<in1 & in2<in3 ) 
				in2 = min( in1, in3 );
			elseif( in2>in1 & in2>in3 )
				in2 = max( in1, in3 );		
			end
			set( H.temp(3), 'Value', in2 );
			set( H.temp(4), 'String', in2 );
		end
		if( mode(2) == 1  | mode(2) == 3 )
			set( H.temp(3), 'Value', ...
				round(100*mean([in1 in3]))/100 );
			set( H.temp(4), 'String', ...
				round(100*mean([in1 in3]))/100 );
		end
		set( H.temp(5), 'Value', in3 );
		set( H.temp(6), 'String', in3 );

		set( H.temp(7), 'Value', out1 );
		set( H.temp(8), 'String', out1 );
		if( mode(2) == 5 ) % ADJUST MIDDLE SLIDER
			if( out2<out1 & out2<out3 ) 
				out2 = min( out1, out3 );
			elseif( out2>out1 & out2>out3 )
				out2 = max( out1, out3 );		
			end
			set( H.temp(9), 'Value', out2 );
			set( H.temp(10), 'String', out2 );
		end
		if( mode(2) == 4  | mode(2) == 6 )
			set( H.temp(9), 'Value', ...
				round(100*mean([out1 out3]))/100 );
			set( H.temp(10), 'String', ...
				round(100*mean([out1 out3]))/100 );
		end
		set( H.temp(11), 'Value', out3 );
		set( H.temp(12), 'String', out3 );
	end
	
	vals = [in1 in2 in3 out1 out2 out3 H.temp(15)];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
