%%%
%%% Q_INPUT: 	NON-MENU ROUTINE.
%%%
%%%		Setup GUI input devices with default settings. Call
%%%		with figure number, position of GUI, and for slider
%%%		[min max initial] values, and for all others a string
%%%		containing the name.  Returns handle to GUI.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[ h ] = Q_input( parent, position, values, type );

if( strcmp( type, 'slider' ) )
	h	= uicontrol;
	set( h, 'Parent', parent );
	set( h, 'Units', 'normalized' );
	set( h, 'FontSize', 10 );
	set( h, 'Style', 'slider' );
	set( h, 'Position', position );
	set( h, 'Interruptible', 'off' );
	set( h, 'Min', values(1), 'Max', values(2), 'Value', values(3) );
	set( h, 'SliderStep', [values(4) values(5)] );
elseif( strcmp( type, 'edit' ) )
	h	= uicontrol;
	set( h, 'Parent', parent );
	set( h, 'Units', 'normalized' );
	set( h, 'FontSize', 10 );
	set( h, 'Style', 'edit' );
	set( h, 'Position', position );
	set( h, 'String', values );
elseif( strcmp( type, 'text' ) )
	h	= uicontrol;
	set( h, 'Parent', parent );
	set( h, 'Units', 'normalized' );
	set( h, 'FontSize', 10 );
	set( h, 'Style', 'text' );
	set( h, 'Position', position );
	set( h, 'String', values );
	set( h, 'BackGroundColor', get(gcf,'Color') );
	set( h, 'HorizontalAlignment', 'center' );
elseif( strcmp( type, 'pushbutton' ) )
	h	= uicontrol;
	set( h, 'Parent', parent );
	set( h, 'Units', 'normalized' );
	set( h, 'FontSize', 10 );
	set( h, 'Style', 'pushbutton' );
	set( h, 'Position', position );
	set( h, 'String', values );
	set( h, 'HorizontalAlignment', 'center' );
elseif( strcmp( type, 'checkbox' ) )
	h	= uicontrol;
	set( h, 'Parent', parent );
	set( h, 'Units', 'normalized' );
	set( h, 'FontSize', 10 );
	set( h, 'Style', 'checkbox' );
	set( h, 'Position', position );
	set( h, 'String', values );
	set( h, 'HorizontalAlignment', 'center' );
else
	h = -1;
end