%%%
%%% Q_HISOGRAM: HISTOGRAM AND IMAGE STASTICS.
%%%
%%%		Compute histogram of displayed pixels (mode=1) or of
%%%		underlying image pixels (mode=2).  Report various
%%%		statistics (see Q_hist.m). 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_histogram( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	IM		= Q_get_iminfo( parent );
	if( mode == 1 )	% display mode - put image through colormap
		IM2	= IM;
		IM2.im	= 255*Q_cmaplookup( IM.cmap, IM.clim, IM.im );
		[N,X,S]	= Q_hist( IM2 );
	elseif( mode == 2 ) % image mode
		[N,X,S]	= Q_hist( IM );
	end
	Q_window( parent, IM, N, X, S );
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent, IM, N, X, S )

	Q_expandfig( parent, 'Histogram', 1, 0 );
	Q_show_hist( parent, [0.6 0.55 0.37 0.35], N, X, S );
	xlim(1)	= S.minval;
	xlim(1) = xlim(1)-0.05*abs(xlim(1));
	xlim(2)	= S.maxval;
	xlim(2) = xlim(2)+0.05*abs(xlim(2));

	set( gca, 'XLim', xlim );
	set( gca, 'XTick', round(10*[S.minval S.meanval S.maxval])/10 );
	set( gca, 'YTick', round([0 max(N)]) );
	set( gca, 'XGrid', 'off' );

	subplot( 'position', [0.6 0.1 0.3 0.35] ); 
	axis off;
	text( 0, 1.00, sprintf( '%7s %7.1f', 'min', S.minval ), ...
		 'FontName', 'Clean', 'FontSize', 12 );
	text( 0, 0.85, sprintf( '%7s %7.1f', 'max', S.maxval ), ...
		 'FontName', 'Clean', 'FontSize', 12 );
	text( 0, 0.70, sprintf( '%7s %7.1f', 'mean', S.meanval ), ...
		 'FontName', 'Clean', 'FontSize', 12 );	
	text( 0, 0.55, sprintf( '%7s %7.1f', 'median', S.medval ), ...
		 'FontName', 'Clean', 'FontSize', 12 );	
	text( 0, 0.40, sprintf( '%7s %7.1f', 'std dev', S.stddev ), ...
		 'FontName', 'Clean', 'FontSize', 12 );
	text( 0, 0.25, sprintf( '%7s %7d (%d x %d)', 'pixels', S.npix, size(IM.im,1), size(IM.im,2)  ), 'FontName', 'Clean', 'FontSize', 12 );

