%%%
%%% Q_HIST:	NON-MENU ROUTINE. 
%%%
%%% 		Compute histogram and various image statisitcs.  The
%%% 		histogram is returned in two 1D vectors [N,X], where X
%%% 		contains the bin values and N the bin counts.  The
%%% 		image statistics are returned in the structure 
%%% 		S with fields for the min, max, mean, std dev.,
%%% 		median, number of pixels, and bottom 1% and top 99%
%%% 		pixel intensity value. 
%%%
%%%		For speed, image is subsampled and number of bins is
%%% 		fixed at 20.
%%%
%%% 		This routine is called by Q_histogram.m and various
%%% 		routines that need to display a histogram (e.g.,
%%% 		Q_brightness.m and Q_levels.m). 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[ N, X, S ] = Q_hist( IM )

	im		= IM.im;
	[ydim,xdim]     = size( im );
	syfact		= max( 1, floor(0.02*ydim) );
	sxfact		= max( 1, floor(0.02*xdim) );
	nbin		= 20; % number of bins

	%%% FOR SPEED: COMPUTE HISTOGRAM ON SUBSAMPLED IMAGE
	im		= im( 1:syfact:ydim, 1:sxfact:xdim );
	im		= im( : );
	[N,X]           = hist( im, nbin );

	S.minval	= min( im );
	S.maxval	= max( im );
	S.meanval 	= mean( im );  
	S.stddev  	= std( im );
	S.medval 	= median( im );
	S.npix    	= ydim * xdim;
	im		= sort( im );
	dim		= size(im,1);
	S.one		= im( ceil(0.01*dim) );
	S.ninetynine	= im( floor(0.99*dim) );
