%%%
%%% Q_GRADIENT: COMPUTE EDGE GRADIENT.
%%%
%%%		Compute edge gradient as sum of squares of partial
%%%		derivates in X and Y.  Differentiation filters are
%%%		separable 3-tap filters (farid&simoncelli, 1997).
%%%		Final image is normalized into [0 1]. 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_gradient( parent );

	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	pre	= Q_filters( 'pre3' );
	deriv	= Q_filters( 'deriv3' );
	im_x	= Q_conv( Q_conv(IM.im, pre'), deriv );
	im_y	= Q_conv( Q_conv(IM.im, pre), deriv' );
	im2	= sqrt( im_x.^2 + im_y.^2 );
	im2	= im2 - min(im2(:));
	im2	= im2 / max(im2(:));
	IM.im	= im2;
	IM.clim	= [0 1];
	Q_show_im( IM, parent );
	Q_active( parent, 0 );