%%%
%%% Q_GET_XY: 	NON-MENU ROUTINE.
%%%	
%%%		Return x,y cursor position in figure.  Does the
%%%		right thing when the image is magnified, or reshaped.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [x,y] = Q_get_xy( parent );

	set( parent, 'Units', 'pixels' );
	IM		= Q_get_iminfo( parent );
	[ydim,xdim]	= size( IM.im );
	fig_pos		= get( parent, 'Position' );

	im_dims		= [xdim ydim]; % flip x/y
	fig_dims	= [fig_pos(3) fig_pos(4)];
	scale		= im_dims ./ fig_dims;
	offset		= fig_dims - im_dims./max(scale);
	scale		= im_dims ./ (fig_dims-offset);

	mouse_pos	= get( parent, 'CurrentPoint' );
	x		= mouse_pos(1) + 1;
	x		= scale(1) * (x - offset(1)/2);
	x		= max( x, 1 );
	x		= min( x, im_dims(1) );

	y		= fig_dims(2) - mouse_pos(2) + 1;
	y		= scale(2) * (y - offset(2)/2);
	y		= max( y, 1 );
	y		= min( y, im_dims(2) );

	set( parent, 'Units', 'normalized' );
