%%%
%%% Q_GET_IMAGE: NON-MENU ROUTINE.
%%%
%%%		Return all the figure information stored in the figure
%%%		field UserData.  If called with undo=1, return the
%%%		image information stored in the undo buffer.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[ IM ] = Q_get_iminfo( fig, undo )

	h		= get( fig, 'UserData' );
	if( exist('undo') & undo==1 )
		IM.im		= h.image.undo.im;
		IM.cmap		= h.image.undo.cmap;
		IM.clim		= h.image.undo.clim;
		IM.filename	= h.image.undo.filename;
		IM.magnify	= h.image.undo.magnify;
		IM.mode		= h.image.undo.mode;
	else
		IM.im		= h.image.im;
		IM.cmap		= h.image.cmap;
		IM.clim		= h.image.clim;
		IM.filename	= h.image.filename;
		IM.magnify	= h.image.magnify;
		IM.mode		= h.image.mode;
	end