%%%
%%% Q_GAUSSIANBLUR: BLUR WITH A GAUSSIAN.
%%%
%%%		Blur image with a two-dimensional Gaussian filter,
%%%		control the radius of the Gaussian.  Convolution is
%%%		performed with 1-D separable Gaussian filters.  See
%%%		also Q_blur.m 
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_gaussianblur( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	Q_window( parent );
	Q_sliders( parent, IM );
	Q_callbacks( parent );
	Q_gaussianblur( str2num(sprintf('%d',parent)), 0, 1 );
else 
	if( mode == 1 | mode == 2 ) % PREVIEW
		vals	= Q_getvals( parent, mode );	
		IM	= Q_get_iminfo( parent );
		im2	= blur( Q_make_preview_im(IM.im), vals );
		Q_preview_im( im2, parent, 0 );
	elseif( mode == 3 ) % OK
		vals	= Q_getvals( parent, mode );	
		IM	= Q_get_iminfo( parent );
		IM.im	= blur( IM.im, vals );
		Q_resetfig( parent, IM );
		return;
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Gaussian Blur', 1, 1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent, IM )

	H 	= Q_get_handles( parent );

	limit	= min( size(IM.im) ) / 2 - 1;
	
	%%% SLIDER/EDIT/LABEL
	H.temp(1) = Q_input( parent, [0.6 0.37 0.25 0.06], ...
				[0 limit 0 2/limit 10/limit], 'slider' );
	H.temp(2) = Q_input( parent, [0.86 0.37 0.12 0.06], 0, 'edit' );
	H.temp(3) = Q_input( parent, [0.86 0.30 0.12 0.06], ...
				'Radius (pixels)', 'text' );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );
	cmd1 	= sprintf( 'Q_gaussianblur(%d,0,1);', parent );
	cmd2 	= sprintf( 'Q_gaussianblur(%d,0,2);', parent );
	cmd3 	= sprintf( 'Q_gaussianblur(%d,0,3);', parent );

	%%% SLIDER/EDIT
	set( H.temp(1), 'Callback', cmd1 );
	set( H.temp(2), 'Callback', cmd2 );
	set( H.ok, 'Callback', cmd3 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent, mode )

	H	= Q_get_handles( parent );

	if( mode == 1 | mode == 3 | mode == 4 ) % SLIDER INPUT
		r	= round(get( H.temp(1), 'Value' ));
		set(  H.temp(2), 'String', r );
	elseif( mode == 2 ) % EDIT INPUT
		r	= str2num( get( H.temp(2), 'String' ) );
		if( isempty(r) ) r = 0; end;
		r	= max( r, get(  H.temp(1), 'Min' ) );
		r	= min( r, get(  H.temp(1), 'Max' ) );
		set( H.temp(1), 'Value', r );
		set( H.temp(2), 'String', r );
	end
	vals 	= r;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[ im2 ] = blur( im, r )
	
	if( r == 0 )
		im2 = im;
	else
		xramp   = [-r : r];
		sig     = r/4;
		gauss   = exp( -xramp.^2 / (2*sig^2) );
		gauss   = gauss / sum(gauss);
		im2 	= Q_conv( im, gauss );
		im2	= Q_conv( im2, gauss' );
	end
