%%%
%%% Q_FOURIER: 	FOURIER TRANSFORM.
%%%
%%%		Compute Fourier transform and decompose into magnitude
%%%		and phase.  For display purpose, the log of the
%%%		magnitude is displayed.  Select checkboxes to create
%%%		new figures with the log magnitude and/or phase images.
%%%
%%% DATE: 	July 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_fourier( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	Q_window( parent );
	Q_sliders( parent );
	Q_callbacks( parent );
else 
	if( mode == 1 ) % OK
		IM	= Q_get_iminfo( parent );
		H	= Q_get_handles( parent );
		vals	= Q_getvals( parent );
		if( any(vals) )
			[mag,phase] = fourier( IM.im );
		end
		Q_resetfig( parent, IM );
		if( vals(2) )	% PHASE
			Q_main( phase, gray(256), [-pi pi], 1, 'gray', ...
				sprintf( '%s_Fourier_phase', IM.filename ) );
		end
		if( vals(1) )	% MAGNITUDE
			Q_main( mag, gray(256), [0 max(mag(:))], 1, 'gray', ...
				sprintf( '%s_Fourier_logmag', IM.filename ) );
		end
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Fourier', 1, 1 );

	%%% COMPUTE MAGNITUDE/PHASE AND DISPLAY
	IM		= Q_get_iminfo( parent );
	[mag,phase]	= fourier( Q_make_preview_im( IM.im ) );

	Q_preview_im( mag, parent, 1, gray(256), [0 1], ...
			 [0.53 0.05 0.35 0.35] );
	Q_preview_im( phase, parent, 1, gray(256), [-pi pi] );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_sliders( parent )

	H 	= Q_get_handles( parent );
	
	%%% MAGNITUDE/PHASE CHECKBOXES
	H.temp(1) = Q_input( parent, [0.82 0.05 0.14 0.06], ...
				'Magnitude', 'checkbox' );
	H.temp(2) = Q_input( parent, [0.82 0.55 0.14 0.06], ...
				'Phase', 'checkbox' );

	set( H.temp(1), 'Value', 0 );
	set( H.temp(2), 'Value', 0 );

	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );
	cmd1 	= sprintf( 'Q_fourier(%d,0,1);', parent );

	%%% OK CALLBACK
	set( H.ok, 'Callback', cmd1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent )

	H 	= Q_get_handles( parent );
	vals	= [ get(H.temp(1),'Value') get(H.temp(2),'Value') ]; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[ mag, phase ] = fourier( im )

	im_F 	= fftshift( fft2( fftshift( im ) ) );
	mag	= log10( abs( im_F ) + 1 );
	phase	= angle( im_F );