%%%
%%% Q_FLIP: 	FLIP IMAGE.
%%%
%%%		Flip image  horizontally (k=1) or vertically (k=0).
%%%		Uses built-in matlab function fliplr and flipud.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_flip( parent, k )

	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	if( k == 1 )	
		IM.im = fliplr( IM.im );
	elseif(  k == 0 )
		IM.im = flipud( IM.im );
	end
	Q_show_im( IM, parent );
	Q_active( parent, 0 );	
