%%%
%%% Q_FILTERS: NON-MENU ROUTINE.
%%%
%%%		Define and return a number of convolution filters used
%%%		throughout.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [ filt ] = Q_filters( name )

	if( strcmp( name, 'binom3' ) )
		filt = 1/4 * [1 2 1];
	elseif( strcmp( name, 'binom4' ) )
		filt = 1/8 * [1 3 3 1];
	elseif( strcmp( name, 'binom5' ) )
		filt = 1/16 * [1 4 6 4 1]; 
	elseif( strcmp( name, 'binom6' ) )
		filt = 1/32 * [1 5 10 10 5 1]; 
	elseif( strcmp( name, 'binom7' ) )
		filt = 1/64 * [1 6 15 20 15 6 1]; 
	elseif( strcmp( name, 'blur' ) )
		filt = 1/8 * [0 1 0 ; 1 4 1 ; 0 1 0]; 
	elseif( strcmp( name, 'deriv3' ) )
		filt = [-0.453014 0.0 0.453014 ]; 
	elseif( strcmp( name, 'pre3' ) )
		filt = [0.223755 0.552490 0.223755]; 
	elseif( strcmp( name, 'sharpen' ) )
		filt = 1/8 * [0 -1 0 ; -1 12 -1 ; 0 -1 0]; 
	else
		filt = [1]; % unknown filter name, return impulse
	end