%%%
%%% Q_FILTER_ARBITRARY: CONVOLVE IMAGE WITH ARBITRARY FILTER.
%%%
%%%		Convolve image with arbitary 7 x 7 filter.  Control
%%%		any of the 49 filter values, entry left blank is
%%%		assumed to be zero. Reset to return filter to impulse, 
%%%		and Autoscale to force pixel values to fill entire
%%%		range.  Convolution is performed only after clicking
%%%		on the Preview, Reset or Autoscale buttons.  
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_filter_arbitrary( parent, first, mode );

if( first )
	if( Q_active(parent,1) )
		return;
	end

	Q_window( parent );
	Q_sliders( parent );
	Q_callbacks( parent );
	Q_filter_arbitrary( str2num(sprintf('%d',parent)), 0, 1 );
else 
	if( mode == 1 ) % PREVIEW
		vals	= Q_getvals( parent );	
		IM	= Q_get_iminfo( parent );
		H	= Q_get_handles( parent );	
		im	= Q_conv( Q_make_preview_im(IM.im), vals );
		auto	= get( H.temp(52), 'Value' ); % autoscale
		Q_preview_im( im, parent, auto )
	elseif( mode == 2 ) % RESET
		Q_setvals( parent );
	elseif( mode == 3 ) % OK
		vals	= Q_getvals( parent );	
		IM	= Q_get_iminfo( parent );
		H	= Q_get_handles( parent );	
		IM.im	= Q_conv( IM.im, vals );
		auto	= get( H.temp(52), 'Value' ); % autoscale
		if( auto )
			IM.clim = [min(IM.im(:)) max(IM.im(:))];
		end
		Q_resetfig( parent, IM );
		return;
	end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_window( parent )

	Q_expandfig( parent, 'Arbitrary Fitler', 1, 1 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ h ] = Q_sliders( parent )

	H 	= Q_get_handles( parent );

	%%% FILTER TAPS
	c 	= 1;
	for y = 1 : 7
		for x = 1 : 7
			H.temp(c) = Q_input( parent, ...
				[0.6+(x-1)*.055 0.45-(y-1)*.06 0.055 0.06], ...
				0, 'edit' );
			c = c + 1;
		end
	end
	set( H.temp(25), 'String', 1 );

	%%% PREVIEW/RESET/AUTOSCALE
	H.temp(50) = Q_input( parent, [0.82 0.55 0.14 0.06], ...
				'Preview', 'pushbutton' );
	H.temp(51) = Q_input( parent, [0.82 0.65 0.14 0.06], ...
				'Reset', 'pushbutton' );
	H.temp(52) = Q_input( parent, [0.82 0.75 0.14 0.06], ...
				'Autoscale', 'checkbox' );
	
	Q_set_handles( H, parent );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Q_callbacks( parent )

	H 	= Q_get_handles( parent );
	cmd1 	= sprintf( 'Q_filter_arbitrary(%d,0,1);', parent );
	cmd2 	= sprintf( 'Q_filter_arbitrary(%d,0,2);', parent );
	cmd3 	= sprintf( 'Q_filter_arbitrary(%d,0,3);', parent );

	%%% PREVIEW/RESET AND AUTOSCALE
	set( H.temp(50), 'Callback', cmd1 );
	set( H.temp(51), 'Callback', cmd2 );
	set( H.temp(52), 'Callback', cmd1 );
	set( H.ok, 'Callback', cmd3 );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ vals ] = Q_getvals( parent )

	H	= Q_get_handles( parent );
	vals 	= zeros( 7 );	% convolution filter
	c 	= 1;
	for y = 1 : 7
		for x = 1 : 7
			if( isempty( get(H.temp(c),'String') ) )
				vals(y,x) = 0;
			else
				vals(y,x)=str2num(get(H.temp(c),'String'));
			end
			c = c + 1;		
		end
	end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [ ] = Q_setvals( parent )

	H	= Q_get_handles( parent );
	c 	= 1;
	for y = 1 : 7
		for x = 1 : 7
			set( H.temp(c), 'String', 0 );
			c = c + 1;
		end
	end
	set( H.temp(25), 'String', 1 );	 % reset filter to impulse
	Q_filter_arbitrary( str2num(sprintf('%d',parent)), 0, 1 );
