%%%
%%% Q_EXPANDFIG: NON-MENU ROUTINE.
%%%
%%%		Called whenever a menu option requires space in the
%%%		figure (replaces earlier Q_newwindow.m).  Enlarge the
%%%		current figure to twice its width and move the
%%%		existing image over to the left. Create OK/CANCEL
%%%		buttons (specified by 0/1 variables in function call)
%%%		with default callbacks that call Q_resetfig.m.
%%%
%%% DATE: 	June 23, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[ ] = Q_expandfig( parent, name, ok, cancel )

	IM		= Q_get_iminfo( parent );
	H		= Q_get_handles( parent );

	%%% RESIZE FIGURE
	pos		= get( parent, 'Position' );
	pos2		= [pos(1) pos(2) 2*pos(3) pos(4)];
	set( parent, 'Position', pos2 );
	set( gca, 'Position', [0 0 0.5 1] );

	%%% OK AND CANCEL BUTTONS
	H.ok		= uimenu( parent, 'Label', 'OK' );
	if( ok )
		cmd	= sprintf( 'Q_resetfig(%d);', parent );
		set( H.ok, 'Callback', cmd );
	else
		set( H.ok, 'Visible', 'off' );
	end

	H.cancel	= uimenu( parent, 'Label', 'CANCEL' );
	if( cancel )
		cmd	= sprintf( 'Q_resetfig(%d);', parent );
		set( H.cancel, 'Callback', cmd );
	else
		set( H.cancel, 'Visible', 'off' );	
	end

	%%% TURN OFF MOUSE MOTION FUNCTION
	set( parent, 'Pointer', 'arrow' );
	set( parent, 'WindowButtonMotionFcn', '' );
        set( H.pos, 'String', '' );
        set( H.dval, 'String', '' );
        set( H.ival, 'String', '' );

	%%% LEFT ALIGN IMAGE INFORMATION
	set( H.iminfo, 'Position', [0.0 0.95 0.5 0.04] );

	Q_set_handles( H, parent );
