%%%
%%% Q_EQUALIZE: HISTOGRAM EQUALIZATION.
%%%
%%%		Adjust the display of the image so that the histogram
%%%		is flat.  Effects only the colormap.
%%%
%%% DATE: 	June 13, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_equalize( parent );
	
	if( Q_active(parent,1) )
		return;
	end

	IM		= Q_get_iminfo( parent );
	im		= IM.im(:);
	minim		= min(im);
	maxim		= max(im);
	step		= (maxim-minim)/15;
	X		= [minim : step : maxim];
	N 		= hist(im, X );
	T		= sum( N );
	N2		= cumsum( N ) / T;
	X2		= [minim : (maxim-minim)/255 : maxim];
	N2		= interp1( X, N2, X2, '*linear' );
	IM.cmap		= N2' * [1 1 1];
	Q_show_im( IM, parent );
	Q_active( parent, 0 );