%%%
%%% Q_DEFAULTS: DEFINE AND RETURN DEFAULT VALUES.
%%%
%%%		Define defaults:
%%%			1. image (im) - loaded when Q is called with no
%%%			   	arguments, and when new figure is created
%%%			   	from within Q 
%%%			2. colormap (cmap) - a 256 x 3 matrix
%%%			3. colormap axis (clim) - range of pixel
%%%			   	intensities mapped into colormap
%%%			4. magnification (magnify) - [1/8,1/4,1/2,1,2,4,8]
%%%			5. image format (mode) - currently only 'gray'
%%%			   	is supported.
%%%			6. figure name (filename) - a string.
%%%
%%%		Return individual default value, return a structure
%%%		containing all defaults when called with the string
%%%		'all'. 
%%%
%%% DATE: 	July 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%

function[ val ] = Q_defaults( param )

	D.im		= 128 * ones(256);
	D.cmap		= gray( 256 );
	D.clim		= [0 255];
	D.magnify	= 1;
	D.mode		= 'gray';
	D.filename	= 'untitled';

	val		= get_default( D, param );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[ val ] = get_default( D, param )

	if( strcmp( param, 'all' ) )
		val	= D;
	elseif( isfield( D, param ) )
		val	= getfield( D, param );
	else
		val 	= 0;
	end