%%%
%%% Q_CROP: 	CROP A RECTANGULAR REGION IN THE IMAGE.
%%%
%%%		Click and drag to define rectangular cropping area.
%%%		Click inside the rectangle to crop, and outside the
%%%		rectangle to cancel. 
%%%		
%%% DATE: 	July 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_crop( parent );

	if( Q_active(parent,1) )
		return;
	end

	set( parent, 'WindowButtonMotionFcn','' ); % TURN MOUSE MOTION OFF
	set( parent, 'Units', 'pixels' );

	waitforbuttonpress;
	rect	= rbbox;			% RUBBERBAND RECTANGLE
	rect	= draw_rect( parent, rect );	% DRAW FINAL RECTANGLE
	waitforbuttonpress;			% CLICK IN/OUT TO CROP/CANCEL
	IM = crop( parent, rect );		% CROP OR CANCEL
	Q_show_im( IM, parent )

	set(parent, 'WindowButtonMotionFcn', ...% TURN MOUSE MOTION ON
		sprintf('Q_motionfcn( %d );',parent) );
	set( parent, 'Units', 'normalized' );
	Q_active( parent, 0 );	

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[IM] = crop( parent, rect )

	IM		= Q_get_iminfo( parent );
	figpos		= get( parent, 'Position' );
	clickpos	= get( parent, 'CurrentPoint' );
	[ydim,xdim]	= size( IM.im );
	ydim		= IM.magnify * ydim;
	xdim		= IM.magnify * xdim;
	x		= clickpos(1) - (figpos(3)/2 - xdim/2);
	y		= ydim - (clickpos(2) - (figpos(4)/2 - ydim/2));
	x		= x / IM.magnify;
	y		= y / IM.magnify;

        if( x>rect(1) & x<rect(2) & y>rect(3) & y<rect(4) ) % CROP    
		IM.im = IM.im( rect(3):rect(4), rect(1):rect(2) );
	end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[rect] = draw_rect( parent, rect )

	IM		= Q_get_iminfo( parent );
	pos		= get( parent, 'Position' );
	[ydim,xdim]	= size( IM.im );
	ydim		= IM.magnify * ydim;
	xdim		= IM.magnify * xdim;
	rect(1)		= rect(1) - (pos(3)/2 - xdim/2);
	rect(2)		= ydim - (rect(2) - (pos(4)/2 - ydim/2));
	x0		= rect(1);
	x1		= rect(1) + rect(3);
	y0		= rect(2) - rect(4);
	y1		= rect(2);

	x0		= max( min(x0,xdim), 1 ) / IM.magnify;
	x1		= max( min(x1,xdim), 1 ) / IM.magnify;
	y0		= max( min(y0,ydim), 1 ) / IM.magnify;
	y1		= max( min(y1,ydim), 1 ) / IM.magnify;

	lh = line( [x0 x0], [y0 y1] ); 
	set( lh, 'Color', [1 0 0], 'LineStyle', '--' );
	lh = line( [x1 x1], [y0 y1] ); 
	set( lh, 'Color', [1 0 0], 'LineStyle', '--' );
	lh = line( [x0 x1], [y0 y0] ); 
	set( lh, 'Color', [1 0 0], 'LineStyle', '--' );
	lh = line( [x0 x1], [y1 y1] ); 
	set( lh, 'Color', [1 0 0], 'LineStyle', '--' );

	rect = round( [x0 x1 y0 y1] );
