%%%
%%% Q_CONV: 	NON-MENU ROUTINE.
%%%
%%%		One and two dimensional convolution with kernel h:
%%%			g(x,y) = (f*h)(x,y)
%%%		
%%%		Edges are handled by mirror imaging at boundries,
%%%		final image is same size as original image.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [ g ] = Q_conv( f, h );

	[ydim,xdim]	= size( f );
	[dy,dx]		= size( h ); % amount to wrap
	dy		= ceil( dy/2 );
	dx		= ceil( dx/2 );

	ydim2		= size( f, 1 ) + 2*dy;
	xdim2		= size( f, 2 ) + 2*dx;
	g		= zeros( ydim2, xdim2 );

	% top row, bottom row, left colum, right column
	g(dy+1:ydim2-dy, 1:dx)			= f(1:ydim, dx:-1:1); 
	g(dy+1:ydim2-dy, xdim2-dx+1:xdim2)	= f(1:ydim, xdim:-1:xdim-dx+1);
	g(1:dy, dx+1:xdim2-dx)			= f(dy:-1:1, 1:xdim );
	g(ydim2-dy+1:ydim2, dx+1:xdim2-dx)	= f(ydim:-1:ydim-dy+1, 1:xdim);
	g(dy+1:ydim2-dy, dx+1:xdim2-dx)		= f;

	% top left, top right, bottom left, bottom right corners
	g(1:dy, 1:dx)				= f(dy:-1:1, dx:-1:1);
	g(1:dy, xdim2-dx+1:xdim2)		= f(dy:-1:1,xdim:-1:xdim-dx+1);
	g(ydim2-dy+1:ydim2, 1:dx)		= f(ydim:-1:ydim-dy+1,dx:-1:1);
	g(ydim2-dy+1:ydim2, xdim2-dx+1:xdim2) 	= f(ydim:-1:ydim-dy+1, ...
						    xdim:-1:xdim-dx+1);

	g		= conv2( g, h, 'same' );
	g		= g( dy+1:ydim2-dy, dx+1:xdim2-dx );
