%%%
%%% Q_CMAPLOOKUP: NON-MENU ROUTINE.
%%%
%%%		Put an image (X2) through the specified colormap.  If
%%%		no method is specified perform nearest neighbor
%%%		interpolation. Replace out of range values with -1.
%%%
%%%		Uses only the first column of the colormap - i.e.,
%%%		assumes gray scale images!
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function[ Y2 ] = Q_cmaplookup( cmap, clim, X2, method )

	%%% TABLE LOOKUP
	X1		= [clim(1):(clim(2)-clim(1))/(size(cmap,1)-1):clim(2)];
	Y1		= cmap(:,1);
	X2a		= X2(:);

	if( exist( 'method' ) )
		Y2	= interp1( X1, Y1, X2a, method );
	else
		Y2	= interp1( X1, Y1, X2a, '*nearest' );
	end

	%%% REPLACE NaN with -1
	index           = find( isnan( Y2 ) );  
	Y2(index)       = -1/255*ones( size(index) );
	Y2		= reshape( Y2, size(X2) );
