%%%
%%% Q_BLUR: 	BLUR IMAGE.
%%%
%%%		Blur with a fixed size 3x3 low-pass filter:
%%%			1/8 * [0 1 0 ; 1 4 1 ; 0 1 0]
%%%
%%%		See also Q_gaussianblur.m.
%%%
%%% DATE: 	June 3, 1998
%%% BY:   	Hany Farid (farid@mit.edu), Copyright 1998, MIT.
%%%
function [] = Q_blur( parent );

	if( Q_active(parent,1) )
		return;
	end

	IM	= Q_get_iminfo( parent );
	filt	= Q_filters( 'blur' );
	IM.im	= Q_conv( IM.im, filt );
	Q_show_im( IM, parent );
	Q_active( parent, 0 );	
